/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hudson.plugins.birtcharts;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.EmptyUpdateNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.IGenerator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.hudson.graph.DataSet;
import org.eclipse.hudson.graph.GraphSupport;
import org.eclipse.hudson.graph.MultiStageTimeSeries;
import org.eclipse.hudson.plugins.birtcharts.BirtChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirtChartSupport
extends GraphSupport {
    private String chartTitle;
    private String xAxisLabel;
    private String yAxisLabel;
    private IDeviceRenderer dRenderer = null;
    private int chartType = 3;
    private DataSet dataSet;

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    public void setTitle(String title) {
        this.chartTitle = title;
    }

    public void setXAxisLabel(String xLabel) {
        this.xAxisLabel = xLabel;
    }

    public void setYAxisLabel(String yLabel) {
        this.yAxisLabel = yLabel;
    }

    public BufferedImage render(int width, int height) {
        Chart cm = this.createBirtChart();
        ChartEngine ce = null;
        try {
            PlatformConfig config = new PlatformConfig();
            config.setProperty("STANDALONE", (Object)"true");
            ce = ChartEngine.instance((PlatformConfig)config);
            this.dRenderer = ce.getRenderer("dv.PNG");
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        this.dRenderer.setProperty("device.output.context", (Object)g2d);
        this.dRenderer.setProperty("cached.image", (Object)image);
        try {
            Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)width, (double)height);
            bo.scale(72.0 / (double)this.dRenderer.getDisplayServer().getDpiResolution());
            IGenerator gr = ce.getGenerator();
            IDisplayServer dServer = this.dRenderer.getDisplayServer();
            GeneratedChartState gcs = gr.build(dServer, cm, bo, null, null, null);
            this.dRenderer.setProperty("device.component", (Object)new EmptyUpdateNotifier(cm, gcs.getChartModel()));
            gr.render(this.dRenderer, gcs);
        }
        catch (ChartException ex) {
            ex.printStackTrace();
        }
        return image;
    }

    private Chart createBirtChart() {
        return new BirtChart(this.chartTitle, this.xAxisLabel, this.yAxisLabel, this.dataSet).createChart();
    }

    public void setData(DataSet data) {
        this.dataSet = data;
    }

    public String getImageMap(String id, int width, int height) {
        this.render(width, height);
        String imageMap = ((IImageMapEmitter)this.dRenderer).getImageMap();
        StringBuilder sb = new StringBuilder();
        sb.append("<map id=\"map\" name=\"" + id + "\"'>");
        sb.append(imageMap);
        sb.append("</map>");
        return sb.toString();
    }

    public void setMultiStageTimeSeries(List<MultiStageTimeSeries> multiStageTimeSeries) {
    }
}

