/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.birtcharts;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.integrate.SimpleActionHandle;
import org.eclipse.birt.chart.integrate.SimpleActionUtil;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.render.ActionRendererAdapter;

public class CustomActionRenderer
extends ActionRendererAdapter {
    public void processAction(Action action, StructureSource source) {
        URLValue uv;
        String sa;
        if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType())) {
            TooltipValue tv = (TooltipValue)action.getValue();
            if (StructureType.SERIES_DATA_POINT.equals(source.getType()) && (tv.getText() == null || "".equals(tv.getText()))) {
                DataPointHints dph = (DataPointHints)source.getSource();
                int value = Integer.parseInt(dph.getDisplayValue().trim());
                if (value > 0) {
                    String MyToolTip = dph.getBaseDisplayValue() + ": " + dph.getDisplayValue();
                    tv.setText(MyToolTip);
                } else {
                    tv.setText("");
                }
            }
        }
        if (ActionType.URL_REDIRECT_LITERAL.equals((Object)action.getType()) && (sa = (uv = (URLValue)action.getValue()).getBaseUrl()) != null) {
            SimpleActionHandle handle = SimpleActionUtil.deserializeAction((String)sa);
            String uri = handle.getURI();
            if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
                DataPointHints dph = (DataPointHints)source.getSource();
                uri = uv.getBaseUrl();
                String basedisply = dph.getBaseDisplayValue();
                uri = this.replaceTemplate(uri, Integer.parseInt(basedisply.trim().replaceAll("#", "")));
            }
            uv.setBaseUrl(uri);
            uv.setTarget(handle.getTargetWindow());
        }
    }

    private String replaceTemplate(String baseUrl, int buildNo) {
        int index1 = baseUrl.indexOf("${");
        int index2 = baseUrl.indexOf("}");
        if (index1 > 0 && index2 > 0) {
            String prefix = baseUrl.substring(0, index1 - 1);
            String suffix = baseUrl.substring(index2 + 1);
            baseUrl = prefix + buildNo + suffix;
        }
        return baseUrl;
    }
}

