/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.birtcharts;

import java.awt.Color;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.hudson.graph.DataSet;
import org.eclipse.hudson.graph.GraphSeries;

class BirtChart {
    protected String chartTitle;
    protected String xAxisLabel;
    protected String yAxisLabel;
    protected DataSet dataSet;

    BirtChart(String title, String xLabel, String yLabel, DataSet data) {
        this.chartTitle = title;
        this.xAxisLabel = xLabel;
        this.yAxisLabel = yLabel;
        this.dataSet = data;
    }

    Chart createChart() {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.getBlock().setBackground((Fill)ColorDefinitionImpl.CREAM().brighter());
        chartWithAxes.getBlock().getOutline().setVisible(false);
        chartWithAxes.getTitle().getLabel().getCaption().setValue(this.chartTitle);
        Legend lg = chartWithAxes.getLegend();
        lg.setItemType(LegendItemType.SERIES_LITERAL);
        lg.getText().getFont().setSize(10.0f);
        lg.getText().getFont().setBold(true);
        lg.getInsets().set(5.0, 0.0, 5.0, 5.0);
        lg.getClientArea().getInsets().set(5.0, 5.0, 5.0, 5.0);
        Axis xAxis = chartWithAxes.getPrimaryBaseAxes()[0];
        xAxis.setType(AxisType.TEXT_LITERAL);
        xAxis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxis.getOrigin().setType(IntersectionType.MIN_LITERAL);
        xAxis.getTitle().getCaption().setValue(this.xAxisLabel);
        xAxis.getLabel().getCaption().getFont().setRotation(90.0);
        xAxis.getLabel().getCaption().getFont().setItalic(true);
        xAxis.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE().darker());
        xAxis.getLineAttributes().setColor(ColorDefinitionImpl.BLUE().darker());
        this.setXData(xAxis);
        Axis yAxis = chartWithAxes.getPrimaryOrthogonalAxis(xAxis);
        yAxis.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxis.getTitle().getCaption().setValue(this.yAxisLabel);
        yAxis.getTitle().getCaption().setColor(ColorDefinitionImpl.BLUE().darker());
        yAxis.getLabel().getCaption().getFont().setItalic(true);
        yAxis.getLabel().getCaption().setColor(ColorDefinitionImpl.BLUE().darker());
        yAxis.getLineAttributes().setColor(ColorDefinitionImpl.BLUE().darker());
        yAxis.getTitle().setVisible(true);
        this.setYData(yAxis);
        return chartWithAxes;
    }

    protected void setXData(Axis xAxis) {
        GraphSeries grpahXSeries = this.dataSet.getXSeries();
        String[] seriesData = grpahXSeries.getData().toArray(new String[grpahXSeries.getData().size()]);
        TextDataSet xData = TextDataSetImpl.create((Object)seriesData);
        Series xSeries = SeriesImpl.create();
        xSeries.setDataSet((org.eclipse.birt.chart.model.data.DataSet)xData);
        xSeries.setSeriesIdentifier((Object)grpahXSeries.getCaption());
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xAxis.getSeriesDefinitions().add((Object)xSeriesDefinition);
        xSeriesDefinition.getSeries().add((Object)xSeries);
    }

    protected void setYData(Axis yAxis) {
        List grpahYSerieses = this.dataSet.getYSeries();
        for (GraphSeries grpahYSeries : grpahYSerieses) {
            if (grpahYSeries.getData().size() <= 0) continue;
            Number[] seriesData = grpahYSeries.getData().toArray(new Number[grpahYSeries.getData().size()]);
            NumberDataSet yData = NumberDataSetImpl.create((Object)seriesData);
            Series ySeries = BarSeriesImpl.create();
            switch (grpahYSeries.getType()) {
                case 2: {
                    ySeries = BarSeriesImpl.create();
                    ((BarSeries)ySeries).setRiser(RiserType.TUBE_LITERAL);
                    ySeries.setTranslucent(true);
                    break;
                }
                case 1: {
                    ySeries = AreaSeriesImpl.create();
                    ySeries.setTranslucent(true);
                    AreaSeries areaSeries = (AreaSeries)ySeries;
                    for (int i = 0; i < areaSeries.getMarkers().size(); ++i) {
                        ((Marker)areaSeries.getMarkers().get(i)).setType(MarkerType.CIRCLE_LITERAL);
                        ((Marker)areaSeries.getMarkers().get(i)).setSize(4);
                    }
                    break;
                }
                case 3: {
                    ySeries = LineSeriesImpl.create();
                    LineSeries lineSeries = (LineSeries)ySeries;
                    lineSeries.getLineAttributes().setColor(this.getColor(grpahYSeries.getColor()));
                    for (int i = 0; i < lineSeries.getMarkers().size(); ++i) {
                        ((Marker)lineSeries.getMarkers().get(i)).setType(MarkerType.CIRCLE_LITERAL);
                        ((Marker)lineSeries.getMarkers().get(i)).setSize(2);
                    }
                    break;
                }
            }
            ySeries.setDataSet((org.eclipse.birt.chart.model.data.DataSet)yData);
            if (grpahYSeries.isStacked()) {
                ySeries.setStacked(true);
            }
            ySeries.setSeriesIdentifier((Object)grpahYSeries.getCaption());
            if (grpahYSeries.isValueLabelDisplayed()) {
                ySeries.getLabel().setVisible(true);
            } else {
                ySeries.getLabel().setVisible(false);
            }
            if (grpahYSeries.isLabelInside()) {
                ySeries.setLabelPosition(Position.INSIDE_LITERAL);
                ySeries.getLabel().getCaption().getFont().setRotation(90.0);
            }
            SeriesDefinition ySeriesDefinition = SeriesDefinitionImpl.create();
            ySeriesDefinition.getSeriesPalette().update((Fill)this.getColor(grpahYSeries.getColor()));
            yAxis.getSeriesDefinitions().add((Object)ySeriesDefinition);
            ySeriesDefinition.getSeries().add((Object)ySeries);
            TooltipValue tooltipValue = TooltipValueImpl.create((int)100, (String)"");
            Action tooltipAction = ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)tooltipValue);
            Trigger mouseOverTrigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)tooltipAction);
            ySeries.getTriggers().add((Object)mouseOverTrigger);
            URLValue urlRedirectValue = URLValueImpl.create((String)grpahYSeries.getBaseURL(), null, null, null, null);
            Action urlRedirectAction = ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)urlRedirectValue);
            Trigger mouseClickTrigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)urlRedirectAction);
            ySeries.getTriggers().add((Object)mouseClickTrigger);
            Cursor cursor = AttributeFactory.eINSTANCE.createCursor();
            cursor.setType(CursorType.POINTER);
            ySeries.setCursor(cursor);
        }
    }

    protected ColorDefinition getColor(Color color) {
        return ColorDefinitionImpl.create((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
    }
}

