/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.checkstyle;

import hudson.FilePath;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.checkstyle.CheckStyleMavenResultAction;
import hudson.plugins.checkstyle.CheckStyleProjectAction;
import hudson.plugins.checkstyle.CheckStyleReporterResult;
import hudson.plugins.checkstyle.CheckStyleResult;
import hudson.plugins.checkstyle.parser.CheckStyleParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckStyleReporter
extends HealthAwareReporter<CheckStyleResult> {
    private static final long serialVersionUID = 2272875032054063496L;
    private static final String PLUGIN_NAME = "CHECKSTYLE";
    private static final String CHECKSTYLE_XML_FILE = "checkstyle-result.xml";

    @DataBoundConstructor
    public CheckStyleReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean canComputeNew) {
        super(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, canComputeNew, PLUGIN_NAME);
    }

    protected boolean acceptGoal(String goal) {
        return "checkstyle".equals(goal) || "check".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilesParser checkstyleCollector = new FilesParser(PLUGIN_NAME, CHECKSTYLE_XML_FILE, (AnnotationParser)new CheckStyleParser(this.getDefaultEncoding()), this.getModuleName(pom));
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)checkstyleCollector);
    }

    protected CheckStyleResult createResult(MavenBuild build, ParserResult project) {
        return new CheckStyleReporterResult((AbstractBuild)build, this.getDefaultEncoding(), project);
    }

    protected MavenAggregatedReport createMavenAggregatedReport(MavenBuild build, CheckStyleResult result) {
        return new CheckStyleMavenResultAction(build, (HealthDescriptor)this, this.getDefaultEncoding(), result);
    }

    public List<CheckStyleProjectAction> getProjectActions(MavenModule module) {
        return Collections.singletonList(new CheckStyleProjectAction((AbstractProject)module, this.getResultActionClass()));
    }

    protected Class<CheckStyleMavenResultAction> getResultActionClass() {
        return CheckStyleMavenResultAction.class;
    }
}

