/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CoverageTarget
implements Serializable {
    private static final long serialVersionUID = -1230271515322670492L;
    private Map<CoverageMetric, Integer> targets = new EnumMap(CoverageMetric.class);

    public CoverageTarget() {
    }

    public CoverageTarget(Map<CoverageMetric, Integer> coverage) {
        this.targets.putAll(coverage);
    }

    public boolean isAlwaysMet() {
        for (Integer target : this.targets.values()) {
            if (target == null || target <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (Integer target : this.targets.values()) {
            if (target == null) continue;
            return false;
        }
        return true;
    }

    public Set<CoverageMetric> getFailingMetrics(CoverageResult coverage) {
        EnumSet<CoverageMetric> result = EnumSet.noneOf(CoverageMetric.class);
        for (Map.Entry target : this.targets.entrySet()) {
            Ratio observed = coverage.getCoverage((CoverageMetric)target.getKey());
            if (observed == null || !(this.roundFloatDecimal(observed.getPercentageFloat()) < (float)((Integer)target.getValue()).intValue() / 100000.0f)) continue;
            result.add((CoverageMetric)target.getKey());
        }
        return result;
    }

    public Set<CoverageMetric> getAllMetrics(CoverageResult coverage) {
        EnumSet<CoverageMetric> result = EnumSet.noneOf(CoverageMetric.class);
        for (Map.Entry target : this.targets.entrySet()) {
            Ratio observed = coverage.getCoverage((CoverageMetric)target.getKey());
            if (observed == null) continue;
            result.add((CoverageMetric)target.getKey());
        }
        return result;
    }

    public float getObservedPercent(CoverageResult coverage, CoverageMetric key) {
        for (Map.Entry target : this.targets.entrySet()) {
            Ratio observed = coverage.getCoverage((CoverageMetric)target.getKey());
            if (target.getKey() != key) continue;
            return this.roundFloatDecimal(observed.getPercentageFloat());
        }
        return 0.0f;
    }

    public float getSetPercent(CoverageResult coverage, CoverageMetric key) {
        for (Map.Entry target : this.targets.entrySet()) {
            if (target.getKey() != key) continue;
            return (float)((Integer)target.getValue()).intValue() / 100000.0f;
        }
        return 0.0f;
    }

    public Map<CoverageMetric, Integer> getRangeScores(CoverageTarget min, CoverageResult coverage) {
        return this.getRangeScores(min, coverage.getResults());
    }

    public Map<CoverageMetric, Integer> getRangeScores(CoverageTarget min, Map<CoverageMetric, Ratio> results) {
        EnumMap<CoverageMetric, Integer> result = new EnumMap<CoverageMetric, Integer>(CoverageMetric.class);
        for (Map.Entry target : this.targets.entrySet()) {
            Ratio observed = results.get(target.getKey());
            if (observed == null) continue;
            Integer j = CoverageTarget.calcRangeScore((Integer)((Integer)target.getValue() / 100000), (Integer)((Integer)min.targets.get(target.getKey())), (int)observed.getPercentage());
            result.put((CoverageMetric)target.getKey(), (int)j);
        }
        return result;
    }

    private static int calcRangeScore(Integer max, Integer min, int value) {
        int result;
        if (min == null || min < 0) {
            min = 0;
        }
        if (max == null || max > 100) {
            max = 100;
        }
        if (min > max) {
            min = max - 1;
        }
        if ((result = (int)(100.0f * ((float)value - min.floatValue()) / (max.floatValue() - min.floatValue()))) < 0) {
            return 0;
        }
        if (result > 100) {
            return 100;
        }
        return result;
    }

    public Set<CoverageMetric> getTargets() {
        EnumSet<CoverageMetric> targets = EnumSet.noneOf(CoverageMetric.class);
        for (Map.Entry target : this.targets.entrySet()) {
            if (target.getValue() == null) continue;
            targets.add((CoverageMetric)target.getKey());
        }
        return targets;
    }

    public void setTarget(CoverageMetric metric, Integer target) {
        this.targets.put(metric, target);
    }

    public Integer getTarget(CoverageMetric metric) {
        return (Integer)this.targets.get(metric);
    }

    public void clear() {
        this.targets.clear();
    }

    public float roundFloatDecimal(float input) {
        float rounded = Math.round(input * 100.0f);
        return rounded /= 100.0f;
    }
}

