/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.ExecutedMojo;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.cobertura.CoberturaBuildAction;
import hudson.plugins.cobertura.CoberturaCoverageParser;
import hudson.plugins.cobertura.CoberturaProjectAction;
import hudson.plugins.cobertura.CoberturaPublisherTarget;
import hudson.plugins.cobertura.Messages;
import hudson.plugins.cobertura.renderers.SourceCodePainter;
import hudson.plugins.cobertura.renderers.SourceEncoding;
import hudson.plugins.cobertura.targets.CoverageMetric;
import hudson.plugins.cobertura.targets.CoverageResult;
import hudson.plugins.cobertura.targets.CoverageTarget;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaPublisher
extends Recorder {
    private final String coberturaReportFile;
    private final boolean onlyStable;
    private final boolean failUnhealthy;
    private final boolean failUnstable;
    private final boolean autoUpdateHealth;
    private final boolean autoUpdateStability;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private CoverageTarget failingTarget;
    public static final CoberturaReportFilenameFilter COBERTURA_FILENAME_FILTER = new CoberturaReportFilenameFilter();
    private final SourceEncoding sourceEncoding;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CoberturaPublisher(String coberturaReportFile, boolean onlyStable, boolean failUnhealthy, boolean failUnstable, boolean autoUpdateHealth, boolean autoUpdateStability, SourceEncoding sourceEncoding) {
        this.coberturaReportFile = coberturaReportFile;
        this.onlyStable = onlyStable;
        this.failUnhealthy = failUnhealthy;
        this.failUnstable = failUnstable;
        this.autoUpdateHealth = autoUpdateHealth;
        this.autoUpdateStability = autoUpdateStability;
        this.sourceEncoding = sourceEncoding;
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    public List<CoberturaPublisherTarget> getTargets() {
        float checker;
        CoberturaPublisherTarget target;
        TreeMap<CoverageMetric, CoberturaPublisherTarget> targets = new TreeMap<CoverageMetric, CoberturaPublisherTarget>();
        for (CoverageMetric metric : this.healthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            if ((checker = (float)this.healthyTarget.getTarget(metric).intValue() / 100000.0f) <= 0.001f) {
                checker = Math.round(checker * 100000.0f);
            }
            target.setHealthy(Float.valueOf(checker));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.unhealthyTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            if ((checker = (float)this.unhealthyTarget.getTarget(metric).intValue() / 100000.0f) <= 0.001f) {
                checker = Math.round(checker * 100000.0f);
            }
            target.setUnhealthy(Float.valueOf(checker));
            targets.put(metric, target);
        }
        for (CoverageMetric metric : this.failingTarget.getTargets()) {
            target = (CoberturaPublisherTarget)targets.get((Object)metric);
            if (target == null) {
                target = new CoberturaPublisherTarget();
                target.setMetric(metric);
            }
            if ((checker = (float)this.failingTarget.getTarget(metric).intValue() / 100000.0f) <= 0.001f) {
                checker = Math.round(checker * 100000.0f);
            }
            target.setUnstable(Float.valueOf(checker));
            targets.put(metric, target);
        }
        ArrayList<CoberturaPublisherTarget> result = new ArrayList<CoberturaPublisherTarget>(targets.values());
        return result;
    }

    private void setTargets(List<CoberturaPublisherTarget> targets) {
        this.healthyTarget.clear();
        this.unhealthyTarget.clear();
        this.failingTarget.clear();
        for (CoberturaPublisherTarget target : targets) {
            float rounded;
            if (target.getHealthy() != null) {
                rounded = Math.round(100.0f * target.getHealthy().floatValue());
                rounded = this.roundDecimalFloat(Float.valueOf(rounded));
                this.healthyTarget.setTarget(target.getMetric(), (int)(100000.0f * rounded));
            }
            if (target.getUnhealthy() != null) {
                rounded = Math.round(100.0f * target.getUnhealthy().floatValue());
                rounded = this.roundDecimalFloat(Float.valueOf(rounded));
                this.unhealthyTarget.setTarget(target.getMetric(), (int)(100000.0f * rounded));
            }
            if (target.getUnstable() == null) continue;
            rounded = Math.round(100.0f * target.getUnstable().floatValue());
            rounded = this.roundDecimalFloat(Float.valueOf(rounded));
            this.failingTarget.setTarget(target.getMetric(), (int)(100000.0f * rounded));
        }
    }

    public String getCoberturaReportFile() {
        return this.coberturaReportFile;
    }

    public boolean getOnlyStable() {
        return this.onlyStable;
    }

    public boolean getFailUnhealthy() {
        return this.failUnhealthy;
    }

    public boolean getFailUnstable() {
        return this.failUnstable;
    }

    public boolean getAutoUpdateHealth() {
        return this.autoUpdateHealth;
    }

    public boolean getAutoUpdateStability() {
        return this.autoUpdateStability;
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File getCoberturaReportDir(AbstractItem project) {
        return new File(project.getRootDir(), "cobertura");
    }

    static File[] getCoberturaReports(AbstractBuild<?, ?> build) {
        return build.getRootDir().listFiles(COBERTURA_FILENAME_FILTER);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        MavenModuleSetBuild moduleSetBuild;
        Result threshold;
        Result result = threshold = this.onlyStable ? Result.SUCCESS : Result.UNSTABLE;
        if (build.getResult().isWorseThan(threshold)) {
            listener.getLogger().println("Skipping Cobertura coverage report as build was not " + threshold.toString() + " or better ...");
            return true;
        }
        if (build instanceof MavenBuild) {
            MavenBuild mavenBuild = (MavenBuild)build;
            if (!this.didCoberturaRun(mavenBuild)) {
                listener.getLogger().println("Skipping Cobertura coverage report as mojo did not run.");
                return true;
            }
        } else if (build instanceof MavenModuleSetBuild && !this.didCoberturaRun((moduleSetBuild = (MavenModuleSetBuild)build).getModuleLastBuilds().values())) {
            listener.getLogger().println("Skipping Cobertura coverage report as mojo did not run.");
            return true;
        }
        listener.getLogger().println("Publishing Cobertura coverage report...");
        FilePath[] moduleRoots = build.getModuleRoots();
        boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
        FilePath moduleRoot = multipleModuleRoots ? build.getWorkspace() : build.getModuleRoot();
        File buildCoberturaDir = build.getRootDir();
        FilePath buildTarget = new FilePath(buildCoberturaDir);
        FilePath[] reports = new FilePath[]{};
        try {
            reports = moduleRoot.list(this.coberturaReportFile);
            if (build.getResult().isWorseOrEqualTo(Result.FAILURE) && reports.length == 0) {
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to find coverage results"));
            build.setResult(Result.FAILURE);
        }
        if (reports.length == 0) {
            String msg = "No coverage results were found using the pattern '" + this.coberturaReportFile + "' relative to '" + moduleRoot.getRemote() + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the XML report(s) for Cobertura?";
            listener.getLogger().println(msg);
            build.setResult(Result.FAILURE);
            return true;
        }
        for (int i = 0; i < reports.length; ++i) {
            FilePath targetPath = new FilePath(buildTarget, "coverage" + (i == 0 ? "" : Integer.valueOf(i)) + ".xml");
            try {
                reports[i].copyTo(targetPath);
                continue;
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy coverage from " + reports[i] + " to " + buildTarget));
                build.setResult(Result.FAILURE);
            }
        }
        listener.getLogger().println("Publishing Cobertura coverage results...");
        HashSet<String> sourcePaths = new HashSet<String>();
        CoverageResult result2 = null;
        for (File coberturaXmlReport : CoberturaPublisher.getCoberturaReports(build)) {
            try {
                result2 = CoberturaCoverageParser.parse(coberturaXmlReport, result2, sourcePaths);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to parse " + coberturaXmlReport));
                build.setResult(Result.FAILURE);
            }
        }
        if (result2 != null) {
            Set<CoverageMetric> unhealthyMetrics;
            listener.getLogger().println("Cobertura coverage report found.");
            result2.setOwner(build);
            FilePath paintedSourcesPath = new FilePath(new File(build.getProject().getRootDir(), "cobertura"));
            paintedSourcesPath.mkdirs();
            SourceCodePainter painter = new SourceCodePainter(paintedSourcesPath, sourcePaths, result2.getPaintedSources(), listener, this.getSourceEncoding());
            moduleRoot.act((FilePath.FileCallable)painter);
            CoberturaBuildAction action = CoberturaBuildAction.load(build, result2, this.healthyTarget, this.unhealthyTarget, this.getOnlyStable(), this.getFailUnhealthy(), this.getFailUnstable(), this.getAutoUpdateHealth(), this.getAutoUpdateStability());
            build.getActions().add(action);
            Set<CoverageMetric> failingMetrics = this.failingTarget.getFailingMetrics(result2);
            if (!failingMetrics.isEmpty()) {
                listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
                for (CoverageMetric metric : failingMetrics) {
                    float oldStabilityPercent = this.failingTarget.getObservedPercent(result2, metric);
                    float setStabilityPercent = this.failingTarget.getSetPercent(result2, metric);
                    listener.getLogger().println("    " + metric.getName() + "'s stability is " + this.roundDecimalFloat(Float.valueOf(oldStabilityPercent * 100.0f)) + " and set mininum stability is " + this.roundDecimalFloat(Float.valueOf(setStabilityPercent * 100.0f)) + ".");
                }
                if (!this.getFailUnstable()) {
                    listener.getLogger().println("Setting Build to unstable.");
                    build.setResult(Result.UNSTABLE);
                } else {
                    listener.getLogger().println("Failing build due to unstability.");
                    build.setResult(Result.FAILURE);
                }
            }
            if (this.getFailUnhealthy() && !(unhealthyMetrics = this.unhealthyTarget.getFailingMetrics(result2)).isEmpty()) {
                listener.getLogger().println("Unhealthy for the following metrics:");
                for (CoverageMetric metric : unhealthyMetrics) {
                    float oldHealthyPercent = this.unhealthyTarget.getObservedPercent(result2, metric);
                    float setHealthyPercent = this.unhealthyTarget.getSetPercent(result2, metric);
                    listener.getLogger().println("    " + metric.getName() + "'s health is " + this.roundDecimalFloat(Float.valueOf(oldHealthyPercent * 100.0f)) + " and set minimum health is " + this.roundDecimalFloat(Float.valueOf(setHealthyPercent * 100.0f)) + ".");
                }
                listener.getLogger().println("Failing build because it is unhealthy.");
                build.setResult(Result.FAILURE);
            }
            if (build.getResult() == Result.SUCCESS) {
                if (this.getAutoUpdateHealth()) {
                    this.setNewPercentages(result2, true, listener);
                }
                if (this.getAutoUpdateStability()) {
                    this.setNewPercentages(result2, false, listener);
                }
            }
        } else {
            listener.getLogger().println("No coverage results were successfully parsed.  Did you generate the XML report(s) for Cobertura?");
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    private void setNewPercentages(CoverageResult result, boolean select, BuildListener listener) {
        Set<CoverageMetric> healthyMetrics = this.healthyTarget.getAllMetrics(result);
        if (!healthyMetrics.isEmpty()) {
            for (CoverageMetric metric : healthyMetrics) {
                float oldPercent;
                float newPercent = this.healthyTarget.getObservedPercent(result, metric);
                newPercent = Math.round(newPercent * 100.0f);
                if (select) {
                    oldPercent = this.unhealthyTarget.getSetPercent(result, metric);
                    oldPercent = Math.round(oldPercent * 100.0f);
                } else {
                    oldPercent = this.failingTarget.getSetPercent(result, metric);
                    oldPercent = Math.round(oldPercent * 100.0f);
                }
                if (!(newPercent > oldPercent)) continue;
                if (select) {
                    this.unhealthyTarget.setTarget(metric, (int)(newPercent * 1000.0f));
                    listener.getLogger().println("    " + metric.getName() + "'s new health minimum is: " + this.roundDecimalFloat(Float.valueOf(newPercent)));
                    continue;
                }
                this.failingTarget.setTarget(metric, (int)(newPercent * 1000.0f));
                listener.getLogger().println("    " + metric.getName() + "'s new stability minimum is: " + this.roundDecimalFloat(Float.valueOf(newPercent)));
            }
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new CoberturaProjectAction(project, this.getOnlyStable());
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public SourceEncoding getSourceEncoding() {
        return this.sourceEncoding;
    }

    private boolean didCoberturaRun(Iterable<MavenBuild> mavenBuilds) {
        for (MavenBuild build : mavenBuilds) {
            if (!this.didCoberturaRun(build)) continue;
            return true;
        }
        return false;
    }

    private boolean didCoberturaRun(MavenBuild mavenBuild) {
        for (ExecutedMojo mojo : mavenBuild.getExecutedMojos()) {
            if (!mojo.groupId.equals("org.codehaus.mojo") || !mojo.artifactId.equals("cobertura-maven-plugin") && !mojo.artifactId.equals("cobertura-it-maven-plugin")) continue;
            return true;
        }
        return false;
    }

    public float roundDecimalFloat(Float input) {
        float rounded = Math.round(input.floatValue());
        return rounded /= 100.0f;
    }

    private static class CoberturaReportFilenameFilter
    implements FilenameFilter {
        private CoberturaReportFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith("coverage") && name.endsWith(".xml");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        CoverageMetric[] metrics = new CoverageMetric[]{CoverageMetric.PACKAGES, CoverageMetric.FILES, CoverageMetric.CLASSES, CoverageMetric.METHOD, CoverageMetric.LINE, CoverageMetric.CONDITIONAL};

        DescriptorImpl() {
            super(CoberturaPublisher.class);
        }

        public String getDisplayName() {
            return Messages.CoberturaPublisher_displayName();
        }

        public List<CoverageMetric> getMetrics() {
            return Arrays.asList(this.metrics);
        }

        public List<CoberturaPublisherTarget> getDefaultTargets() {
            ArrayList<CoberturaPublisherTarget> result = new ArrayList<CoberturaPublisherTarget>();
            result.add(new CoberturaPublisherTarget(CoverageMetric.METHOD, Float.valueOf(80.0f), null, null));
            result.add(new CoberturaPublisherTarget(CoverageMetric.LINE, Float.valueOf(80.0f), null, null));
            result.add(new CoberturaPublisherTarget(CoverageMetric.CONDITIONAL, Float.valueOf(70.0f), null, null));
            return result;
        }

        public List<CoberturaPublisherTarget> getTargets(CoberturaPublisher instance) {
            if (instance == null) {
                return this.getDefaultTargets();
            }
            return instance.getTargets();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "cobertura.");
            this.save();
            return super.configure(req, formData);
        }

        public CoberturaPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CoberturaPublisher instance = (CoberturaPublisher)((Object)req.bindJSON(CoberturaPublisher.class, formData));
            ConvertUtils.register((Converter)CoberturaPublisherTarget.CONVERTER, CoverageMetric.class);
            List targets = req.bindParametersToList(CoberturaPublisherTarget.class, "cobertura.target.");
            instance.setTargets(targets);
            return instance;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

