/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class Ratio
implements Serializable {
    public final float numerator;
    public final float denominator;
    static NumberFormat dataFormat = new DecimalFormat("000.00");
    private static final long serialVersionUID = 1L;
    private static final Ratio[] COMMON_INSTANCES = new Ratio[256];

    private Ratio(float numerator, float denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public String toString() {
        return this.print(this.numerator) + "/" + this.print(this.denominator);
    }

    private String print(float f) {
        int i = (int)f;
        if ((float)i == f) {
            return String.valueOf(i);
        }
        return String.valueOf(f);
    }

    public int getPercentage() {
        return Math.round(this.getPercentageFloat());
    }

    public float getPercentageFloat() {
        return this.denominator == 0.0f ? (this.numerator == 0.0f ? 100.0f : 0.0f) : 100.0f * this.numerator / this.denominator;
    }

    public String getPercentageString() {
        return dataFormat.format(this.getPercentageFloat());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio ratio = (Ratio)o;
        return Float.compare(ratio.denominator, this.denominator) == 0 && Float.compare(ratio.numerator, this.numerator) == 0;
    }

    public int hashCode() {
        int result = this.numerator != 0.0f ? Float.floatToIntBits(this.numerator) : 0;
        result = (float)(31 * result) + this.denominator != 0.0f ? Float.floatToIntBits(this.denominator) : 0;
        return result;
    }

    public static Ratio create(float x, float y) {
        int idx;
        int xx = (int)x;
        int yy = (int)y;
        if ((float)xx == x && (float)yy == y && 0 <= (idx = yy * (yy + 1) / 2 + xx) && idx < COMMON_INSTANCES.length) {
            Ratio r = COMMON_INSTANCES[idx];
            if (r == null) {
                Ratio.COMMON_INSTANCES[idx] = r = new Ratio(x, y);
            }
            return r;
        }
        return new Ratio(x, y);
    }
}

