/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura.targets;

import hudson.plugins.cobertura.Ratio;
import hudson.plugins.cobertura.targets.CoverageElement;
import hudson.plugins.cobertura.targets.CoverageMetric;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoveragePaint
implements Serializable {
    private static final long serialVersionUID = -6265259191856193735L;
    protected Map<Integer, CoveragePaintDetails> lines = new HashMap<Integer, CoveragePaintDetails>();

    public CoveragePaint(CoverageElement source) {
    }

    public void paint(int line, int hits) {
        CoveragePaintDetails d = this.lines.get(line);
        if (d == null) {
            d = new CoveragePaintDetails(0, 0, 0);
            this.lines.put(line, d);
        }
        d.hitCount += hits;
    }

    public void paint(int line, int hits, int branchCover, int branchCount) {
        CoveragePaintDetails d = this.lines.get(line);
        if (d == null) {
            d = new CoveragePaintDetails(hits, branchCount, branchCover);
            this.lines.put(line, d);
        } else {
            d.hitCount += hits;
            if (d.branchCount == 0) {
                d.branchCount = branchCount;
                d.branchCoverage = branchCover;
            } else {
                d.branchCount = Math.max(d.branchCount, branchCount);
                d.branchCoverage = Math.max(d.branchCoverage, branchCover);
            }
        }
    }

    public void add(CoveragePaint child) {
        for (Map.Entry<Integer, CoveragePaintDetails> e : child.lines.entrySet()) {
            CoveragePaintDetails d = this.lines.get(e.getKey());
            if (d != null) {
                d.hitCount += e.getValue().hitCount;
                d.branchCount = Math.max(d.branchCount, e.getValue().branchCount);
                if (d.branchCount == 0) continue;
                d.branchCoverage = Math.max(d.branchCoverage, e.getValue().branchCoverage);
                continue;
            }
            CoveragePaintDetails dc = e.getValue();
            d = new CoveragePaintDetails(dc.hitCount, dc.branchCount, dc.branchCoverage);
            this.lines.put(e.getKey(), d);
        }
    }

    public Ratio getLineCoverage() {
        int covered = 0;
        for (CoveragePaintDetails d : this.lines.values()) {
            if (d.hitCount <= 0) continue;
            ++covered;
        }
        return Ratio.create(covered, this.lines.size());
    }

    public Ratio getConditionalCoverage() {
        long maxTotal = 0L;
        long total = 0L;
        for (CoveragePaintDetails d : this.lines.values()) {
            maxTotal += (long)d.branchCount;
            total += (long)d.branchCoverage;
        }
        return Ratio.create(total, maxTotal);
    }

    public Map<CoverageMetric, Ratio> getResults() {
        EnumMap<CoverageMetric, Ratio> result = new EnumMap<CoverageMetric, Ratio>(CoverageMetric.class);
        result.put(CoverageMetric.LINE, this.getLineCoverage());
        result.put(CoverageMetric.CONDITIONAL, this.getConditionalCoverage());
        return result;
    }

    public boolean isPainted(int line) {
        return this.lines.get(line) != null;
    }

    public int getHits(int line) {
        CoveragePaintDetails d = this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.hitCount;
    }

    public int getBranchTotal(int line) {
        CoveragePaintDetails d = this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.branchCount;
    }

    public int getBranchCoverage(int line) {
        CoveragePaintDetails d = this.lines.get(line);
        if (d == null) {
            return 0;
        }
        return d.branchCoverage;
    }

    class CoveragePaintDetails
    implements Serializable {
        private static final long serialVersionUID = -9097537016381444671L;
        int hitCount = 0;
        int branchCount = 0;
        int branchCoverage = 0;

        public CoveragePaintDetails(int hitCount, int branchCount, int branchCoverage) {
            this.hitCount = hitCount;
            this.branchCount = branchCount;
            this.branchCoverage = branchCoverage;
        }
    }
}

