/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cobertura;

import hudson.plugins.cobertura.targets.CoverageMetric;
import org.apache.commons.beanutils.Converter;

public final class CoberturaPublisherTarget {
    private CoverageMetric metric;
    private Float healthy;
    private Float unhealthy;
    private Float unstable;
    public static final Converter CONVERTER = new TargetConverter();

    public CoberturaPublisherTarget() {
    }

    public CoberturaPublisherTarget(CoverageMetric metric, Float healthy, Float unhealthy, Float unstable) {
        this.metric = metric;
        this.healthy = healthy;
        this.unhealthy = unhealthy;
        this.unstable = unstable;
    }

    public CoverageMetric getMetric() {
        return this.metric;
    }

    public void setMetric(CoverageMetric metric) {
        this.metric = metric;
    }

    public Float getHealthy() {
        if (this.healthy == null) {
            return Float.valueOf(80.0f);
        }
        return Float.valueOf((float)Math.round(this.healthy.floatValue() * 100.0f) / 100.0f);
    }

    public void setHealthy(Float healthy) {
        this.healthy = healthy == null ? null : (healthy.floatValue() < 0.0f ? Float.valueOf(0.0f) : (healthy.floatValue() > 100.0f ? Float.valueOf(100.0f) : Float.valueOf((float)Math.round(healthy.floatValue() * 100.0f) / 100.0f)));
    }

    public Float getUnhealthy() {
        if (this.unhealthy == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)Math.round(this.unhealthy.floatValue() * 100.0f) / 100.0f);
    }

    public void setUnhealthy(Float unhealthy) {
        this.unhealthy = unhealthy == null ? null : (unhealthy.floatValue() < 0.0f ? Float.valueOf(0.0f) : (unhealthy.floatValue() > 100.0f ? Float.valueOf(100.0f) : Float.valueOf((float)Math.round(unhealthy.floatValue() * 100.0f) / 100.0f)));
    }

    public Float getUnstable() {
        if (this.unstable == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)Math.round(this.unstable.floatValue() * 100.0f) / 100.0f);
    }

    public void setUnstable(Float unstable) {
        this.unstable = unstable == null ? null : (unstable.floatValue() < 0.0f ? Float.valueOf(0.0f) : (unstable.floatValue() > 100.0f ? Float.valueOf(100.0f) : Float.valueOf((float)Math.round(unstable.floatValue() * 100.0f) / 100.0f)));
    }

    private static class TargetConverter
    implements Converter {
        private TargetConverter() {
        }

        public Object convert(Class type, Object value) {
            return CoverageMetric.valueOf(value.toString());
        }
    }
}

