/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.team.cli;

import hudson.Extension;
import hudson.XmlFile;
import hudson.cli.CLICommand;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.hudson.security.team.Team;
import org.eclipse.hudson.security.team.TeamManager;
import org.eclipse.hudson.security.team.TeamNode;
import org.eclipse.hudson.security.team.TeamView;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class CopyTeamCommand
extends CLICommand {
    @Argument(metaVar="FROM", usage="Team name to copy (required)", required=true, index=0)
    public String from;
    @Argument(metaVar="TO", usage="Team name to create (required)", required=true, index=1)
    public String to;
    @Argument(metaVar="EMAIL", usage="Email recipients separated by commas (optional); if not specified, recipients will be removed", required=false, index=2)
    public String email;
    @Option(name="-n", aliases={"--nodes"}, usage="MOVE (move nodes to new team), VISIBLE (make nodes visible to new team), IGNORE (ignore nodes - default), ")
    public String nodes;
    @Option(name="-v", aliases={"--views"}, usage="MOVE (move views to new team), VISIBLE (make views visible to new team), IGNORE (ignore views - default), ")
    public String views;

    public String getShortDescription() {
        return "Copy a team and its jobs to a newly created team";
    }

    protected int run() throws Exception {
        block20: {
            Team toTeam;
            Team fromTeam;
            TeamManager teamManager;
            block21: {
                Hudson h = Hudson.getInstance();
                if (!h.isTeamManagementEnabled()) {
                    this.stderr.println("Team management is not enabled");
                    return -1;
                }
                teamManager = h.getTeamManager();
                if (!teamManager.isCurrentUserSysAdmin()) {
                    this.stderr.println("User not authorized to create team");
                    return -1;
                }
                try {
                    fromTeam = teamManager.findTeam(this.from);
                }
                catch (TeamManager.TeamNotFoundException e) {
                    this.stderr.println("From team " + this.from + " not found");
                    return -1;
                }
                if (!(this.nodes == null || "move".equalsIgnoreCase(this.nodes) || "visible".equalsIgnoreCase(this.nodes) || "ignore".equalsIgnoreCase(this.nodes))) {
                    this.stderr.println("nodes must be one of move, visible or ignore");
                }
                if (!(this.views == null || "move".equalsIgnoreCase(this.views) || "visible".equalsIgnoreCase(this.views) || "ignore".equalsIgnoreCase(this.views))) {
                    this.stderr.println("views must be one of move, visible or ignore");
                }
                toTeam = null;
                try {
                    toTeam = teamManager.createTeam(this.to);
                }
                catch (IOException ex) {
                    this.stderr.println(ex.getMessage());
                    return -1;
                }
                catch (TeamManager.TeamAlreadyExistsException ex) {
                    this.stderr.println("To team " + this.to + " already exists");
                    return -1;
                }
                Set jobNames = fromTeam.getJobNames();
                for (String jobName : jobNames) {
                    InputStream in;
                    String unqualifiedName = teamManager.getUnqualifiedJobName(jobName);
                    TopLevelItem item = h.getItem(jobName);
                    if (!(item instanceof Job)) continue;
                    Job job = (Job)item;
                    XmlFile file = job.getConfigFile();
                    try {
                        in = this.fixConfigFile(file, this.from, this.to, this.email);
                    }
                    catch (Failure ex) {
                        this.stderr.println("Error reading config.xml for job " + jobName);
                        this.stderr.println(ex.getMessage());
                        return -1;
                    }
                    h.createProjectFromXML(unqualifiedName, this.to, in);
                }
                if (this.nodes != null) {
                    if ("move".equalsIgnoreCase(this.nodes)) {
                        for (String nodeName : fromTeam.getNodeNames()) {
                            teamManager.moveNode(fromTeam, toTeam, nodeName);
                        }
                    } else if ("visible".equalsIgnoreCase(this.nodes)) {
                        for (TeamNode teamNode : fromTeam.getNodes()) {
                            teamManager.addNodeVisibility(teamNode, toTeam.getName());
                            teamManager.setNodeEnabled(teamNode.getId(), toTeam, true);
                        }
                    }
                }
                if (this.views == null) break block20;
                if (!"move".equalsIgnoreCase(this.views)) break block21;
                for (String viewName : fromTeam.getViewNames()) {
                    teamManager.moveView(fromTeam, toTeam, viewName);
                }
                break block20;
            }
            if (!"visible".equalsIgnoreCase(this.nodes)) break block20;
            for (TeamView teamView : fromTeam.getViews()) {
                teamManager.addViewVisibility(teamView, toTeam.getName());
            }
        }
        return 0;
    }

    private InputStream fixConfigFile(XmlFile file, String oldTeam, String newTeam, String email) {
        InputStream in = null;
        String oldPrefix = oldTeam + ".";
        String newPrefix = newTeam + ".";
        try {
            Element properties;
            Element cascadingChildren;
            in = new FileInputStream(file.getFile());
            SAXReader reader = new SAXReader();
            Document doc = reader.read(in);
            Element root = doc.getRootElement();
            Element cascadingParent = root.element("cascadingProjectName");
            if (cascadingParent != null) {
                this.fixTeamName(cascadingParent, oldPrefix, newPrefix);
            }
            if ((cascadingChildren = root.element("cascadingChildrenNames")) != null) {
                for (Object elem : cascadingChildren.elements("string")) {
                    this.fixTeamName((Element)elem, oldPrefix, newPrefix);
                }
            }
            if ((properties = root.element("project-properties")) == null) {
                throw new Failure("Project has no <project-properties>");
            }
            ArrayList<Element> removeEntries = new ArrayList<Element>();
            for (Object ent : properties.elements("entry")) {
                Element baseProp;
                Element projectName;
                Element origValue;
                Element entry = (Element)ent;
                Element extProp = entry.element("external-property");
                Element element = origValue = extProp != null ? extProp.element("originalValue") : null;
                Element str = entry.element("string");
                if (str == null) continue;
                String propName = str.getTextTrim();
                if ("hudson-tasks-Mailer".equals(propName)) {
                    if (extProp == null) continue;
                    if (email == null) {
                        removeEntries.add(entry);
                        continue;
                    }
                    if (origValue == null) continue;
                    this.fixEmailProperty(origValue, email);
                    continue;
                }
                if ("hudson-tasks-BuildTrigger".equals(propName)) {
                    if (origValue == null) continue;
                    this.fixTriggerProperty(origValue, oldPrefix, newPrefix);
                    continue;
                }
                if ("builders".equals(propName)) {
                    List artifacts;
                    Element describableList = entry.element("describable-list-property");
                    origValue = describableList != null ? describableList.element("originalValue") : null;
                    List list = artifacts = origValue != null ? origValue.elements("hudson.plugins.copyartifact.CopyArtifact") : null;
                    if (artifacts != null) {
                        for (Object obj : artifacts) {
                            Element copyArtifact = (Element)obj;
                            Element projectName2 = copyArtifact.element("projectName");
                            this.fixTeamName(projectName2, oldPrefix, newPrefix);
                        }
                    }
                    List multiJob = origValue != null ? origValue.elements("com.tikal.jenkins.plugins.multijob.MultiJobBuilder") : null;
                    for (Object obj : multiJob) {
                        Element builder = (Element)obj;
                        List jobs = builder.elements("phaseJobs");
                        if (jobs == null) continue;
                        for (Object j : jobs) {
                            Element job = (Element)j;
                            List configs = job.elements("com.tikal.jenkins.plugins.multijob.PhaseJobsConfig");
                            if (configs == null) continue;
                            for (Object c : configs) {
                                Element config = (Element)c;
                                Element jobName = config.element("jobName");
                                this.fixTeamName(jobName, oldPrefix, newPrefix);
                            }
                        }
                    }
                    continue;
                }
                if (!"hudson-plugins-redmine-RedmineProjectProperty".equals(propName) || (projectName = (baseProp = entry.element("base-property")) != null ? baseProp.element("projectName") : null) == null) continue;
                this.fixTeamName(projectName, oldPrefix, newPrefix);
            }
            for (Element entry : removeEntries) {
                properties.remove(entry);
            }
            StringWriter writer = new StringWriter();
            doc.write((Writer)writer);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(writer.toString().getBytes("UTF-8"));
            return byteArrayInputStream;
        }
        catch (FileNotFoundException ex) {
            throw new Failure("File not found");
        }
        catch (DocumentException ex) {
            throw new Failure("Unable to parse document");
        }
        catch (IOException ex) {
            throw new Failure("Document write failed");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    private void fixTeamName(Element element, String oldPrefix, String newPrefix) {
        String jobName = element.getTextTrim();
        if (jobName.startsWith(oldPrefix)) {
            element.setText(newPrefix + jobName.substring(oldPrefix.length()));
        }
    }

    private void fixTriggerProperty(Element origValue, String oldPrefix, String newPrefix) {
        Element cp = origValue.element("childProjects");
        String childProjects = cp.getTextTrim();
        ArrayList<String> children = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(childProjects, ", ");
        boolean changed = false;
        while (st.hasMoreTokens()) {
            String child = st.nextToken();
            if (child.startsWith(oldPrefix)) {
                changed = true;
                child = newPrefix + child.substring(oldPrefix.length());
            }
            children.add(child);
        }
        if (changed) {
            childProjects = StringUtils.join(children, (String)", ");
            cp.setText(childProjects);
        }
    }

    private void fixEmailProperty(Element origValue, String email) {
        Element recipients = origValue.element("recipients");
        if (recipients != null) {
            recipients.setText(email);
        }
    }
}

