/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CopyToMasterNotifier
extends Notifier {
    private final String includes;
    private final String excludes;
    private final boolean overrideDestinationFolder;
    private final String destinationFolder;

    @DataBoundConstructor
    public CopyToMasterNotifier(String includes, String excludes, boolean overrideDestinationFolder, String destinationFolder) {
        this.includes = includes;
        this.excludes = excludes;
        this.overrideDestinationFolder = overrideDestinationFolder;
        this.destinationFolder = destinationFolder;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        if (Computer.currentComputer() instanceof SlaveComputer) {
            FilePath destinationFilePath = this.isOverrideDestinationFolder() && StringUtils.isNotBlank((String)this.getDestinationFolder()) ? new FilePath(new File(env.expand(this.getDestinationFolder()))) : CopyToSlaveUtils.getProjectWorkspaceOnMaster((AbstractBuild)build, (PrintStream)listener.getLogger());
            FilePath projectWorkspaceOnSlave = build.getProject().getWorkspace();
            String includes = env.expand(this.getIncludes());
            String excludes = env.expand(this.getExcludes());
            listener.getLogger().printf("[copy-to-slave] Copying '%s', excluding %s, from '%s' on '%s' to '%s' on the master.\n", includes, StringUtils.isBlank((String)excludes) ? "nothing" : '\'' + excludes + '\'', projectWorkspaceOnSlave.toURI(), Computer.currentComputer().getNode(), destinationFilePath.toURI());
            projectWorkspaceOnSlave.copyRecursiveTo(includes, excludes, destinationFilePath);
        } else if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            listener.getLogger().println("[copy-to-slave] The build is taking place on the master node, no copy back to the master will take place.");
        }
        return true;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public boolean isOverrideDestinationFolder() {
        return this.overrideDestinationFolder;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }
}

