/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.CopyToSlaveUtils;
import com.michelin.cio.hudson.plugins.copytoslave.MyFilePath;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CopyToSlaveBuildWrapper
extends BuildWrapper {
    public static final String RELATIVE_TO_HOME = "home";
    public static final String RELATIVE_TO_SOMEWHERE_ELSE = "somewhereElse";
    public static final String RELATIVE_TO_USERCONTENT = "userContent";
    public static final String RELATIVE_TO_WORKSPACE = "workspace";
    private final String includes;
    private final String excludes;
    private final boolean flatten;
    private final boolean includeAntExcludes;
    @Deprecated
    private final boolean hudsonHomeRelative;
    private final String relativeTo;

    @DataBoundConstructor
    public CopyToSlaveBuildWrapper(String includes, String excludes, boolean flatten, boolean includeAntExcludes, String relativeTo, boolean hudsonHomeRelative) {
        this.includes = includes;
        this.excludes = excludes;
        this.flatten = flatten;
        this.includeAntExcludes = includeAntExcludes;
        this.relativeTo = hudsonHomeRelative ? RELATIVE_TO_HOME : (StringUtils.isBlank((String)relativeTo) ? RELATIVE_TO_USERCONTENT : relativeTo);
        this.hudsonHomeRelative = false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        if (StringUtils.isBlank((String)this.getIncludes())) {
            listener.fatalError("[copy-to-slave] No includes have been defined: It is mandatory to define them.");
            return null;
        }
        if (Computer.currentComputer() instanceof Hudson.MasterComputer && RELATIVE_TO_WORKSPACE.equals(this.relativeTo)) {
            listener.getLogger().println("[copy-to-slave] Trying to copy files from the workspace on the master to the same workspace on the same master: No copy will take place.");
        } else {
            FilePath rootFilePathOnMaster = RELATIVE_TO_WORKSPACE.equals(this.relativeTo) ? CopyToSlaveUtils.getProjectWorkspaceOnMaster(build, listener.getLogger()) : (this.getDescriptor().isSomewhereElseEnabled() && RELATIVE_TO_SOMEWHERE_ELSE.equals(this.relativeTo) ? new FilePath(Hudson.getInstance().getChannel(), env.expand(this.getDescriptor().getSomewhereElsePath())) : (this.getDescriptor().isRelativeToHomeEnabled() && RELATIVE_TO_HOME.equals(this.relativeTo) ? Hudson.getInstance().getRootPath() : Hudson.getInstance().getRootPath().child(RELATIVE_TO_USERCONTENT)));
            FilePath projectWorkspaceOnSlave = build.getWorkspace();
            String includes = env.expand(this.getIncludes());
            String excludes = env.expand(this.getExcludes());
            listener.getLogger().printf("[copy-to-slave] Copying '%s', excluding %s, from '%s' on the master to '%s' on '%s'.\n", includes, StringUtils.isBlank((String)excludes) ? "nothing" : '\'' + excludes + '\'', rootFilePathOnMaster.toURI(), projectWorkspaceOnSlave.toURI(), Computer.currentComputer().getNode().getDisplayName());
            MyFilePath.copyRecursiveTo(rootFilePathOnMaster, includes, excludes, this.isFlatten(), this.isIncludeAntExcludes(), projectWorkspaceOnSlave);
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return this.setUp(build, launcher, listener);
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getRelativeTo() {
        if (this.hudsonHomeRelative) {
            return RELATIVE_TO_HOME;
        }
        if (StringUtils.isBlank((String)this.relativeTo)) {
            return RELATIVE_TO_USERCONTENT;
        }
        return this.relativeTo;
    }

    public boolean isIncludeAntExcludes() {
        return this.includeAntExcludes;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        private boolean relativeToHomeEnabled;
        private boolean somewhereElseEnabled;
        private String somewhereElsePath;

        public DescriptorImpl() {
            super(CopyToSlaveBuildWrapper.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            try {
                this.relativeToHomeEnabled = req.getSubmittedForm().getBoolean("relativeToHomeEnabled");
                this.somewhereElseEnabled = req.getSubmittedForm().getBoolean("somewhereElseEnabled");
                this.somewhereElsePath = req.getSubmittedForm().getString("somewhereElsePath");
                if (StringUtils.isBlank((String)this.somewhereElsePath)) {
                    this.somewhereElsePath = null;
                    this.somewhereElseEnabled = false;
                }
                this.save();
                return true;
            }
            catch (ServletException e) {
                return false;
            }
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(CopyToSlaveBuildWrapper.class), "DisplayName", new Object[0]).toString();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getSomewhereElsePath() {
            return this.somewhereElsePath;
        }

        public boolean isRelativeToHomeEnabled() {
            return this.relativeToHomeEnabled;
        }

        public boolean isSomewhereElseEnabled() {
            return this.somewhereElseEnabled;
        }
    }
}

