/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.copytoslave;

import com.michelin.cio.hudson.plugins.copytoslave.MyGlobDirScanner;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.Hudson;
import hudson.org.apache.tools.tar.TarInputStream;
import hudson.remoting.Future;
import hudson.remoting.Pipe;
import hudson.remoting.VirtualChannel;
import hudson.util.FileVisitor;
import hudson.util.IOException2;
import hudson.util.IOUtils;
import hudson.util.io.Archiver;
import hudson.util.io.ArchiverFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.tar.TarEntry;
import org.hudsonci.plugins.jna.GNUCLibrary;

public class MyFilePath
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static int copyRecursiveTo(FilePath source, final String includes, final String excludes, final boolean flatten, final boolean includeAntExcludes, final FilePath target) throws IOException, InterruptedException {
        if (source.getChannel() == target.getChannel()) {
            return new FilePath.FileCallable<Integer>(){

                public Integer invoke(File sourceBaseDir, VirtualChannel channel) throws IOException {
                    if (!sourceBaseDir.exists()) {
                        return 0;
                    }
                    try {
                        FileSet fs = Util.createFileSet((File)sourceBaseDir, (String)includes, (String)excludes);
                        if (includeAntExcludes) {
                            fs.setDefaultexcludes(false);
                        }
                        class CopyImpl
                        extends Copy {
                            private int copySize;

                            public CopyImpl() {
                                this.setProject(new Project());
                            }

                            protected void doFileOperations() {
                                this.copySize = this.fileCopyMap.size();
                                super.doFileOperations();
                            }

                            public int getNumCopied() {
                                return this.copySize;
                            }
                        }
                        CopyImpl copyTask = new CopyImpl();
                        copyTask.setTodir(new File(target.getRemote()));
                        copyTask.addFileset(fs);
                        copyTask.setOverwrite(true);
                        copyTask.setIncludeEmptyDirs(false);
                        copyTask.setFlatten(flatten);
                        copyTask.execute();
                        return copyTask.getNumCopied();
                    }
                    catch (BuildException e) {
                        throw new IOException2("Failed to copy from " + sourceBaseDir + " to " + target, (Throwable)e);
                    }
                }
            }.invoke(new File(source.getRemote()), (VirtualChannel)Hudson.MasterComputer.localChannel);
        }
        final Pipe pipe = Pipe.createLocalToRemote();
        Future future = target.actAsync((FilePath.FileCallable)new FilePath.FileCallable<Void>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void invoke(File f, VirtualChannel channel) throws IOException {
                try {
                    MyFilePath.readFromTar(f, flatten, FilePath.TarCompression.GZIP.extract(pipe.getIn()));
                    Void void_ = null;
                    return void_;
                }
                finally {
                    pipe.getIn().close();
                }
            }
        });
        int r = MyFilePath.writeToTar(new File(source.getRemote()), includes, excludes, includeAntExcludes, FilePath.TarCompression.GZIP.compress(pipe.getOut()));
        try {
            future.get();
        }
        catch (ExecutionException e) {
            throw new IOException2((Throwable)e);
        }
        return r;
    }

    public static void readFromTar(File baseDir, boolean flatten, InputStream in) throws IOException {
        block16: {
            Chmod chmodTask = null;
            TarInputStream t = new TarInputStream(in);
            block8: while (true) {
                try {
                    TarEntry tarEntry;
                    while ((tarEntry = t.getNextEntry()) != null) {
                        File f = null;
                        if (!flatten || !tarEntry.getName().contains("/") && !tarEntry.getName().contains("\\")) {
                            f = new File(baseDir, tarEntry.getName());
                        } else {
                            String fileName = StringUtils.substringAfterLast((String)tarEntry.getName(), (String)"/");
                            if (StringUtils.isBlank((String)fileName)) {
                                fileName = StringUtils.substringAfterLast((String)tarEntry.getName(), (String)"\\");
                            }
                            f = new File(baseDir, fileName);
                        }
                        if (!flatten && tarEntry.isDirectory()) {
                            f.mkdirs();
                            continue;
                        }
                        if (!flatten && f.getParentFile() != null) {
                            f.getParentFile().mkdirs();
                        }
                        IOUtils.copy((InputStream)t, (File)f);
                        f.setLastModified(tarEntry.getModTime().getTime());
                        int mode = tarEntry.getMode() & 0x1FF;
                        if (mode == 0 || Functions.isWindows()) continue;
                        try {
                            GNUCLibrary.LIBC.chmod(f.getPath(), mode);
                            continue block8;
                        }
                        catch (NoClassDefFoundError ncdfe) {
                        }
                        catch (UnsatisfiedLinkError ule) {
                            if (chmodTask == null) {
                                chmodTask = new Chmod();
                            }
                            chmodTask.setProject(new Project());
                            chmodTask.setFile(f);
                            chmodTask.setPerm(Integer.toOctalString(mode));
                            chmodTask.execute();
                        }
                    }
                    break block16;
                }
                catch (IOException e) {
                    throw new IOException2("Failed to extract to " + baseDir.getAbsolutePath(), (Throwable)e);
                }
            }
            finally {
                t.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer writeToTar(File baseDir, String includes, String excludes, boolean includeAntExcludes, OutputStream out) throws IOException {
        Archiver tw = ArchiverFactory.TAR.create(out);
        try {
            new MyGlobDirScanner(includes, excludes, includeAntExcludes).scan(baseDir, (FileVisitor)tw);
        }
        finally {
            tw.close();
        }
        return tw.countEntries();
    }
}

