/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.diagnosis.OldDataMonitor;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BaseBuildableProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Copier;
import hudson.plugins.copyartifact.CopyMethod;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.ParametersBuildFilter;
import hudson.plugins.copyartifact.StatusBuildSelector;
import hudson.plugins.copyartifact.WorkspaceSelector;
import hudson.security.SecurityRealm;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyArtifact
extends Builder {
    private String projectName;
    private final String filter;
    private final String target;
    private BuildSelector selector;
    @Deprecated
    private transient Boolean stable;
    private final Boolean flatten;
    private final Boolean optional;

    @DataBoundConstructor
    public CopyArtifact(String projectName, BuildSelector selector, String filter, String target, boolean flatten, boolean optional) {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            ItemGroup context = (ItemGroup)req.findAncestorObject(ItemGroup.class);
            if (context == null) {
                context = Hudson.getInstance();
            }
            if (projectName.indexOf(36) < 0 && new JobResolver((ItemGroup)context, (String)projectName).job == null) {
                projectName = "";
            }
        }
        this.projectName = projectName;
        this.selector = selector;
        this.filter = Util.fixNull((String)filter).trim();
        this.target = Util.fixNull((String)target).trim();
        this.flatten = flatten ? Boolean.TRUE : null;
        this.optional = optional ? Boolean.TRUE : null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BuildSelector getBuildSelector() {
        return this.selector;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isFlatten() {
        return this.flatten != null && this.flatten != false;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        PrintStream console = listener.getLogger();
        String expandedProject = this.projectName;
        String expandedFilter = this.filter;
        try {
            FilePath targetDir;
            EnvVars env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            expandedProject = env.expand(this.projectName);
            JobResolver job = new JobResolver(build.getProject().getParent(), expandedProject);
            if (job.job != null && !expandedProject.equals(this.projectName) && !job.job.getACL().hasPermission((Authentication)new UsernamePasswordAuthenticationToken((Object)"authenticated", (Object)"", new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY}), Item.READ)) {
                job.job = null;
            }
            if (job.job == null) {
                console.println(Messages.CopyArtifact_MissingProject(expandedProject));
                console.println(job);
                return false;
            }
            Run<?, ?> src = this.selector.getBuild(job.job, env, job.filter, (Run<?, ?>)build);
            if (src == null) {
                console.println(Messages.CopyArtifact_MissingBuild(expandedProject));
                return this.isOptional();
            }
            FilePath baseTargetDir = targetDir = build.getWorkspace();
            if (targetDir == null || !targetDir.exists()) {
                console.println(Messages.CopyArtifact_MissingWorkspace());
                return this.isOptional();
            }
            EnvAction envData = (EnvAction)build.getAction(EnvAction.class);
            if (envData != null) {
                envData.add(expandedProject, src.getNumber());
            }
            if (this.target.length() > 0) {
                targetDir = new FilePath(targetDir, env.expand(this.target));
            }
            if ((expandedFilter = env.expand(this.filter)).trim().length() == 0) {
                expandedFilter = "**";
            }
            Copier copier = Copier.from((CopyMethod)Hudson.getInstance().getExtensionList(CopyMethod.class).get(0)).clone();
            System.out.println(Hudson.getInstance().getExtensionList(CopyMethod.class));
            if (src instanceof MavenModuleSetBuild) {
                boolean ok = this.perform(src, build, expandedFilter, targetDir, baseTargetDir, copier, console);
                for (MavenBuild r : ((MavenModuleSetBuild)src).getModuleLastBuilds().values()) {
                    ok |= this.perform((Run)r, build, expandedFilter, targetDir, baseTargetDir, copier, console);
                }
                return ok;
            }
            if (src instanceof MatrixBuild) {
                boolean ok = false;
                for (MatrixRun r : ((MatrixBuild)src).getRuns()) {
                    ok |= this.perform((Run)r, build, expandedFilter, targetDir.child(r.getParent().getName()), baseTargetDir, copier, console);
                }
                return ok;
            }
            return this.perform(src, build, expandedFilter, targetDir, baseTargetDir, copier, console);
        }
        catch (IOException ex) {
            Util.displayIOException((IOException)ex, (TaskListener)listener);
            ex.printStackTrace(listener.error(Messages.CopyArtifact_FailedToCopy(expandedProject, expandedFilter)));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean perform(Run src, AbstractBuild<?, ?> dst, String expandedFilter, FilePath targetDir, FilePath baseTargetDir, Copier copier, PrintStream console) throws IOException, InterruptedException {
        boolean useWs = this.selector instanceof WorkspaceSelector || src instanceof AbstractBuild && !(src instanceof MavenBuild);
        FilePath srcDir = null;
        if (useWs) {
            srcDir = ((AbstractBuild)src).getWorkspace();
        }
        if (srcDir == null || !srcDir.exists()) {
            if (this.isOptional()) {
                console.println(Messages.CopyArtifact_MissingSrcWorkspace());
                return this.isOptional();
            }
            srcDir = new FilePath(src.getArtifactsDir());
        }
        copier.init(src, dst, srcDir, baseTargetDir);
        try {
            int cnt;
            if (!this.isFlatten()) {
                cnt = copier.copyAll(srcDir, expandedFilter, targetDir);
            } else {
                FilePath[] list;
                targetDir.mkdirs();
                for (FilePath file : list = srcDir.list(expandedFilter)) {
                    copier.copyOne(file, new FilePath(targetDir, file.getName()));
                }
                cnt = list.length;
            }
            console.println(Messages.CopyArtifact_Copied(cnt, HyperlinkNote.encodeTo((String)('/' + src.getParent().getUrl()), (String)src.getParent().getFullDisplayName()), HyperlinkNote.encodeTo((String)('/' + src.getUrl()), (String)Integer.toString(src.getNumber()))));
            boolean bl = cnt > 0 || this.isOptional();
            return bl;
        }
        finally {
            copier.end();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private EnvAction() {
        }

        private void add(String projectName, int buildNumber) {
            if (this.data == null) {
                return;
            }
            int i = projectName.indexOf(47);
            if (i > 0) {
                projectName = projectName.substring(0, i);
            }
            this.data.put("COPYARTIFACT_BUILD_NUMBER_" + projectName.toUpperCase().replaceAll("[^A-Z]+", "_"), Integer.toString(buildNumber));
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class CopyArtifactRunListener
    extends RunListener<Build> {
        public CopyArtifactRunListener() {
            super(Build.class);
        }

        public void onStarted(Build r, TaskListener listener) {
            if (((BaseBuildableProject)r.getProject()).getBuildersList().get(CopyArtifact.class) != null) {
                r.addAction((Action)new EnvAction());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class ListenerImpl
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            for (AbstractProject project : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                for (CopyArtifact ca : ListenerImpl.getCopiers(project)) {
                    try {
                        if (ca.getProjectName().equals(oldName)) {
                            ca.projectName = newName;
                        } else {
                            if (!ca.getProjectName().startsWith(oldName + '/')) continue;
                            ca.projectName = newName + ca.projectName.substring(oldName.length());
                        }
                        project.save();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ListenerImpl.class.getName()).log(Level.WARNING, "Failed to resave project " + project.getName() + " for project rename in CopyArtifact build step (" + oldName + " =>" + newName + ")", ex);
                    }
                }
            }
        }

        private static List<CopyArtifact> getCopiers(AbstractProject project) {
            DescribableList list;
            Object object = project instanceof Project ? ((Project)project).getBuildersList() : (list = project instanceof MatrixProject ? ((MatrixProject)project).getBuildersList() : null);
            if (list == null) {
                return Collections.emptyList();
            }
            return list.getAll(CopyArtifact.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckProjectName(@AncestorInPath AbstractItem anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Job<?, ?> item = new JobResolver((ItemGroup)anc.getParent(), (String)value).job;
            FormValidation result = item != null ? (item instanceof MavenModuleSet ? FormValidation.warning((String)Messages.CopyArtifact_MavenProject()) : (item instanceof MatrixProject ? FormValidation.warning((String)Messages.CopyArtifact_MatrixProject()) : FormValidation.ok())) : (value.indexOf(36) >= 0 ? FormValidation.warning((String)Messages.CopyArtifact_ParameterizedName()) : FormValidation.error((String)hudson.tasks.Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName())));
            return result;
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public String getDisplayName() {
            return Messages.CopyArtifact_DisplayName();
        }

        public DescriptorExtensionList<BuildSelector, Descriptor<BuildSelector>> getBuildSelectors() {
            return Hudson.getInstance().getDescriptorList(BuildSelector.class);
        }
    }

    private static class JobResolver {
        Job<?, ?> job;
        BuildFilter filter = new BuildFilter();

        JobResolver(ItemGroup context, String projectName) {
            ParametersBuildFilter pFilter;
            Job candidate;
            int i;
            this.job = this.getItem(context, projectName);
            if (this.job == null && (i = projectName.lastIndexOf(47)) > 0 && (candidate = this.getItem(context, projectName.substring(0, i))) != null && (pFilter = new ParametersBuildFilter(projectName.substring(i + 1))).isValid(candidate)) {
                this.job = candidate;
                this.filter = pFilter;
            }
        }

        private Job getItem(ItemGroup context, String pathName) {
            Hudson hudson = Hudson.getInstance();
            if (context == null) {
                context = hudson;
            }
            if (pathName == null) {
                return null;
            }
            if (pathName.startsWith("/")) {
                return (Job)hudson.getItemByFullName(pathName, Job.class);
            }
            ItemGroup ctx = context;
            StringTokenizer tokens = new StringTokenizer(pathName, "/");
            while (tokens.hasMoreTokens()) {
                String s = tokens.nextToken();
                if (s.equals("..")) {
                    if (ctx instanceof Item) {
                        ctx = ((Item)ctx).getParent();
                        continue;
                    }
                    ctx = null;
                    break;
                }
                if (s.equals(".")) continue;
                if (ctx instanceof ItemGroup) {
                    Item i;
                    ItemGroup g = ctx;
                    try {
                        i = g.getItem(s);
                    }
                    catch (Exception e) {
                        i = null;
                    }
                    if (i == null || !i.hasPermission(Item.READ)) {
                        ctx = null;
                        break;
                    }
                    ctx = i;
                    continue;
                }
                return null;
            }
            if (ctx instanceof Job) {
                return (Job)ctx;
            }
            return (Job)hudson.getItemByFullName(pathName, Job.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConverterImpl
    extends XStream2.PassthruConverter<CopyArtifact> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(CopyArtifact obj, UnmarshallingContext context) {
            if (obj.selector == null) {
                obj.selector = new StatusBuildSelector(obj.stable != null && obj.stable != false);
                OldDataMonitor.report((UnmarshallingContext)context, (String)"1.355");
            }
        }
    }
}

