/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.BuildFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersBuildFilter
extends BuildFilter {
    private List<StringParameterValue> filters = new ArrayList(5);
    private static final Pattern PARAMVAL_PATTERN = Pattern.compile("(.*?)=([^,]*)(,|$)");

    public ParametersBuildFilter(String paramsToMatch) {
        Matcher m = PARAMVAL_PATTERN.matcher(paramsToMatch);
        while (m.find()) {
            this.filters.add(new StringParameterValue(m.group(1), m.group(2)));
        }
    }

    public boolean isValid(Job<?, ?> job) {
        if (this.filters.isEmpty()) {
            return false;
        }
        block2: for (Run run = job.getLastCompletedBuild(); run != null; run = run.getPreviousCompletedBuild()) {
            try {
                EnvVars env = run.getEnvironment(TaskListener.NULL);
                for (StringParameterValue spv : this.filters) {
                    if (env.containsKey((Object)spv.getName())) continue;
                    continue block2;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isSelectable(Run<?, ?> run, EnvVars env) {
        EnvVars otherEnv;
        try {
            otherEnv = run.getEnvironment(TaskListener.NULL);
        }
        catch (Exception ex) {
            return false;
        }
        for (StringParameterValue spv : this.filters) {
            if (spv.value.equals(otherEnv.get((Object)spv.getName()))) continue;
            return false;
        }
        return true;
    }
}

