/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggeredBuildSelector
extends BuildSelector {
    private Boolean fallbackToLastSuccessful;
    @Extension(ordinal=25.0)
    public static final Descriptor<BuildSelector> DESCRIPTOR = new SimpleBuildSelectorDescriptor(TriggeredBuildSelector.class, Messages._TriggeredBuildSelector_DisplayName());

    @DataBoundConstructor
    public TriggeredBuildSelector(boolean fallback) {
        this.fallbackToLastSuccessful = fallback ? Boolean.TRUE : null;
    }

    public boolean isFallbackToLastSuccessful() {
        return this.fallbackToLastSuccessful != null && this.fallbackToLastSuccessful != false;
    }

    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        String jobName = job instanceof MatrixConfiguration ? job.getParent().getFullName() : job.getFullName();
        for (Cause cause : parent instanceof MatrixRun ? ((MatrixRun)parent).getParentBuild().getCauses() : parent.getCauses()) {
            if (!(cause instanceof Cause.UpstreamCause) || !jobName.equals(((Cause.UpstreamCause)cause).getUpstreamProject())) continue;
            Run run = job.getBuildByNumber(((Cause.UpstreamCause)cause).getUpstreamBuild());
            return run != null && filter.isSelectable(run, env) ? run : null;
        }
        if (this.isFallbackToLastSuccessful()) {
            return super.getBuild(job, env, filter, parent);
        }
        return null;
    }

    protected boolean isSelectable(Run<?, ?> run, EnvVars env) {
        return this.isFallbackToLastSuccessful() && run.getResult().isBetterOrEqualTo(Result.SUCCESS);
    }
}

