/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Copier;
import hudson.plugins.copyartifact.CopyArtifact;
import hudson.plugins.copyartifact.CopyMethod;
import hudson.plugins.copyartifact.Messages;
import hudson.plugins.copyartifact.WorkspaceSelector;
import hudson.security.SecurityRealm;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CopyArtifact
extends Builder {
    private String projectName;
    private final String filter;
    private final String target;
    private BuildSelector selector;
    @Deprecated
    private transient Boolean stable;
    private final Boolean flatten;
    private final Boolean optional;

    @DataBoundConstructor
    public CopyArtifact(String projectName, BuildSelector selector, String filter, String target, boolean flatten, boolean optional) {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            ItemGroup context = (ItemGroup)req.findAncestorObject(ItemGroup.class);
            if (context == null) {
                context = Hudson.getInstance();
            }
            if (projectName.indexOf(36) < 0 && new JobResolver((ItemGroup)context, (String)projectName).job == null) {
                projectName = "";
            }
        }
        this.projectName = projectName;
        this.selector = selector;
        this.filter = Util.fixNull((String)filter).trim();
        this.target = Util.fixNull((String)target).trim();
        this.flatten = flatten ? Boolean.TRUE : null;
        this.optional = optional ? Boolean.TRUE : null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public BuildSelector getBuildSelector() {
        return this.selector;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isFlatten() {
        return this.flatten != null && this.flatten != false;
    }

    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        PrintStream console = listener.getLogger();
        String expandedProject = this.projectName;
        String expandedFilter = this.filter;
        try {
            FilePath targetDir;
            EnvVars env = build.getEnvironment((TaskListener)listener);
            env.overrideAll(build.getBuildVariables());
            expandedProject = env.expand(this.projectName);
            JobResolver job = new JobResolver(build.getProject().getParent(), expandedProject);
            if (job.job != null && !expandedProject.equals(this.projectName) && !job.job.getACL().hasPermission((Authentication)new UsernamePasswordAuthenticationToken((Object)"authenticated", (Object)"", Arrays.asList(SecurityRealm.AUTHENTICATED_AUTHORITY)), Item.READ)) {
                job.job = null;
            }
            if (job.job == null) {
                console.println(Messages.CopyArtifact_MissingProject((Object)expandedProject));
                return false;
            }
            Run src = this.selector.getBuild(job.job, env, job.filter, build);
            if (src == null) {
                console.println(Messages.CopyArtifact_MissingBuild((Object)expandedProject));
                return this.isOptional();
            }
            FilePath baseTargetDir = targetDir = build.getWorkspace();
            if (targetDir == null || !targetDir.exists()) {
                console.println(Messages.CopyArtifact_MissingWorkspace());
                return this.isOptional();
            }
            EnvAction envData = (EnvAction)build.getAction(EnvAction.class);
            if (envData != null) {
                EnvAction.access$200((EnvAction)envData, (String)expandedProject, (int)src.getNumber());
            }
            if (this.target.length() > 0) {
                targetDir = new FilePath(targetDir, env.expand(this.target));
            }
            if ((expandedFilter = env.expand(this.filter)).trim().length() == 0) {
                expandedFilter = "**";
            }
            Copier copier = Copier.from((CopyMethod)((CopyMethod)Hudson.getInstance().getExtensionList(CopyMethod.class).get(0))).clone();
            if (src instanceof MavenModuleSetBuild) {
                boolean ok = this.perform(src, build, expandedFilter, targetDir, baseTargetDir, copier, console);
                for (Run r : ((MavenModuleSetBuild)src).getModuleLastBuilds().values()) {
                    ok |= this.perform(r, build, expandedFilter, targetDir, baseTargetDir, copier, console);
                }
                return ok;
            }
            if (src instanceof MatrixBuild) {
                boolean ok = false;
                for (Run r : this.getExactRuns((MatrixBuild)src)) {
                    ok |= this.perform(r, build, expandedFilter, targetDir.child(r.getParent().getName()), baseTargetDir, copier, console);
                }
                return ok;
            }
            return this.perform(src, build, expandedFilter, targetDir, baseTargetDir, copier, console);
        }
        catch (IOException ex) {
            Util.displayIOException((IOException)ex, (TaskListener)listener);
            ex.printStackTrace(listener.error(Messages.CopyArtifact_FailedToCopy((Object)expandedProject, (Object)expandedFilter)));
            return false;
        }
    }

    public List<MatrixRun> getExactRuns(MatrixBuild mb) {
        ArrayList<MatrixRun> r = new ArrayList<MatrixRun>();
        for (MatrixConfiguration c : ((MatrixProject)mb.getParent()).getItems()) {
            MatrixRun b = (MatrixRun)c.getBuildByNumber(mb.getNumber());
            if (b == null) continue;
            r.add(b);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean perform(Run src, AbstractBuild<?, ?> dst, String expandedFilter, FilePath targetDir, FilePath baseTargetDir, Copier copier, PrintStream console) throws IOException, InterruptedException {
        FilePath srcDir;
        boolean useWs = this.selector instanceof WorkspaceSelector && src instanceof AbstractBuild;
        FilePath filePath = srcDir = useWs ? ((AbstractBuild)src).getWorkspace() : new FilePath(src.getArtifactsDir());
        if (srcDir == null || !srcDir.exists()) {
            console.println(useWs ? Messages.CopyArtifact_MissingSrcWorkspace() : Messages.CopyArtifact_MissingSrcArtifacts((Object)srcDir));
            return this.isOptional();
        }
        copier.init(src, dst, srcDir, baseTargetDir);
        try {
            int cnt;
            if (!this.isFlatten()) {
                cnt = copier.copyAll(srcDir, expandedFilter, targetDir);
            } else {
                FilePath[] list;
                targetDir.mkdirs();
                for (FilePath file : list = srcDir.list(expandedFilter)) {
                    copier.copyOne(file, new FilePath(targetDir, file.getName()));
                }
                cnt = list.length;
            }
            console.println(Messages.CopyArtifact_Copied((Object)cnt, (Object)HyperlinkNote.encodeTo((String)('/' + src.getParent().getUrl()), (String)src.getParent().getFullDisplayName()), (Object)HyperlinkNote.encodeTo((String)('/' + src.getUrl()), (String)Integer.toString(src.getNumber()))));
            boolean bl = cnt > 0 || this.isOptional();
            return bl;
        }
        finally {
            copier.end();
        }
    }

    static /* synthetic */ BuildSelector access$000(CopyArtifact x0) {
        return x0.selector;
    }

    static /* synthetic */ BuildSelector access$002(CopyArtifact x0, BuildSelector x1) {
        x0.selector = x1;
        return x0.selector;
    }

    static /* synthetic */ Boolean access$100(CopyArtifact x0) {
        return x0.stable;
    }

    static /* synthetic */ String access$302(CopyArtifact x0, String x1) {
        x0.projectName = x1;
        return x0.projectName;
    }

    static /* synthetic */ String access$300(CopyArtifact x0) {
        return x0.projectName;
    }
}

