/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Fingerprint;
import hudson.model.FingerprintMap;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.plugins.copyartifact.Copier;
import hudson.tasks.Fingerprinter;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(ordinal=-100.0)
public class FingerprintingCopyMethod
extends Copier {
    private static final Logger LOGGER = Logger.getLogger(FingerprintingCopyMethod.class.getName());
    private AbstractBuild<?, ?> src;
    private AbstractBuild<?, ?> dst;
    private final MessageDigest md5 = this.newMD5();
    private final Map<String, String> fingerprints = new HashMap();

    public void init(Run src, AbstractBuild<?, ?> dst, FilePath srcDir, FilePath baseTargetDir) throws IOException, InterruptedException {
        this.src = src instanceof AbstractBuild ? (AbstractBuild)src : null;
        this.dst = dst;
        this.fingerprints.clear();
    }

    private MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int copyAll(FilePath srcDir, String filter, FilePath targetDir) throws IOException, InterruptedException {
        FilePath[] list;
        targetDir.mkdirs();
        for (FilePath file : list = srcDir.list(filter)) {
            String tail = file.getRemote().substring(srcDir.getRemote().length());
            if (tail.startsWith("\\") || tail.startsWith("/")) {
                tail = tail.substring(1);
            }
            this.copyOne(file, new FilePath(targetDir, tail));
        }
        return list.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOne(FilePath s, FilePath d) throws IOException, InterruptedException {
        try {
            this.md5.reset();
            DigestOutputStream out = new DigestOutputStream(d.write(), this.md5);
            try {
                s.copyTo((OutputStream)out);
            }
            finally {
                out.close();
            }
            d.chmod(s.mode());
            try {
                d.touch(s.lastModified());
            }
            catch (IOException x) {
                LOGGER.warning(x.getMessage());
            }
            String digest = Util.toHexString((byte[])this.md5.digest());
            FingerprintMap map = Hudson.getInstance().getFingerprintMap();
            Fingerprint f = map.getOrCreate(this.src, s.getName(), digest);
            if (this.src != null) {
                f.add(this.src);
            }
            f.add(this.dst);
            this.fingerprints.put(s.getName(), digest);
        }
        catch (IOException e) {
            throw new IOException2("Failed to copy " + s + " to " + d, (Throwable)e);
        }
    }

    public void end() {
        for (AbstractBuild r : new AbstractBuild[]{this.src, this.dst}) {
            if (r == null) continue;
            Fingerprinter.FingerprintAction fa = (Fingerprinter.FingerprintAction)r.getAction(Fingerprinter.FingerprintAction.class);
            if (fa != null) {
                fa.add(this.fingerprints);
                continue;
            }
            r.getActions().add(new Fingerprinter.FingerprintAction(r, this.fingerprints));
        }
    }

    public Copier clone() {
        return new FingerprintingCopyMethod();
    }
}

