/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.PermalinkProjectAction;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.util.ListBoxModel;
import java.util.StringTokenizer;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermalinkBuildSelector
extends BuildSelector {
    public final String id;

    @DataBoundConstructor
    public PermalinkBuildSelector(String id) {
        this.id = id;
    }

    @Override
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        PermalinkProjectAction.Permalink p = job.getPermalinks().get(this.id);
        if (p == null) {
            return null;
        }
        Run run = p.resolve(job);
        return run != null && filter.isSelectable(run, env) ? run : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<BuildSelector> {
        public String getDisplayName() {
            return Messages.PermalinkBuildSelector_DisplayName();
        }

        public Item getItem(String pathName, ItemGroup context) {
            if (context == null) {
                context = Hudson.getInstance();
            }
            if (pathName == null) {
                return null;
            }
            if (pathName.startsWith("/")) {
                return Hudson.getInstance().getItemByFullName(pathName);
            }
            ItemGroup ctx = context;
            StringTokenizer tokens = new StringTokenizer(pathName, "/");
            while (tokens.hasMoreTokens()) {
                String s = tokens.nextToken();
                if (s.equals("..")) {
                    if (ctx instanceof Item) {
                        ctx = ((Item)ctx).getParent();
                        continue;
                    }
                    ctx = null;
                    break;
                }
                if (s.equals(".")) continue;
                if (ctx instanceof ItemGroup) {
                    ItemGroup g = ctx;
                    Item i = g.getItem(s);
                    if (i == null || !i.hasPermission(Item.READ)) {
                        ctx = null;
                        break;
                    }
                    ctx = i;
                    continue;
                }
                return null;
            }
            if (ctx instanceof Item) {
                return (Item)ctx;
            }
            return Hudson.getInstance().getItemByFullName(pathName);
        }

        public ListBoxModel doFillIdItems(@AncestorInPath Job defaultJob, @RelativePath(value="..") @QueryParameter(value="projectName") String projectName) {
            Job j = null;
            Item item = this.getItem(projectName, defaultJob.getParent());
            if (projectName != null) {
                Job job = j = Job.class.isInstance(item) ? (Job)Job.class.cast(item) : null;
            }
            if (j == null) {
                j = defaultJob;
            }
            ListBoxModel r = new ListBoxModel();
            for (PermalinkProjectAction.Permalink p : j.getPermalinks()) {
                r.add((Object)new ListBoxModel.Option(p.getDisplayName(), p.getId()));
            }
            return r;
        }
    }
}

