/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v5.ConfigurationService;
import com.coverity.ws.v5.ConfigurationServiceService;
import com.coverity.ws.v5.CovRemoteServiceException_Exception;
import com.coverity.ws.v5.DefectService;
import com.coverity.ws.v5.DefectServiceService;
import com.coverity.ws.v5.MergedDefectDataObj;
import com.coverity.ws.v5.MergedDefectFilterSpecDataObj;
import com.coverity.ws.v5.MergedDefectsPageDataObj;
import com.coverity.ws.v5.PageSpecDataObj;
import com.coverity.ws.v5.ProjectDataObj;
import com.coverity.ws.v5.ProjectFilterSpecDataObj;
import com.coverity.ws.v5.StreamDataObj;
import com.coverity.ws.v5.StreamFilterSpecDataObj;
import com.coverity.ws.v5.StreamIdDataObj;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import jenkins.plugins.coverity.ClientAuthenticationHandlerWSS;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMInstance {
    public static final String COVERITY_V5_NAMESPACE = "http://ws.coverity.com/v5";
    public static final String CONFIGURATION_SERVICE_V5_WSDL = "/ws/v5/configurationservice?wsdl";
    public static final String DEFECT_SERVICE_V5_WSDL = "/ws/v5/defectservice?wsdl";
    public static final String STREAM_NAME_IGNORE_PATTERN = "__internal_.*";
    private final String name;
    private final String host;
    private final int port;
    private final int dataPort;
    private final String user;
    private final String password;
    private final boolean useSSL;
    private transient DefectServiceService defectServiceService;
    private transient ConfigurationServiceService configurationServiceService;
    private transient Map<String, Long> projectKeys;

    @DataBoundConstructor
    public CIMInstance(String name, String host, int port, String user, String password, boolean useSSL, int dataPort) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.useSSL = useSSL;
        this.dataPort = dataPort;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.isUseSSL() ? "https" : "http", this.host, this.port, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefectService getDefectService() throws IOException {
        CIMInstance cIMInstance = this;
        synchronized (cIMInstance) {
            if (this.defectServiceService == null) {
                this.defectServiceService = new DefectServiceService(new URL(this.getURL(), DEFECT_SERVICE_V5_WSDL), new QName(COVERITY_V5_NAMESPACE, "DefectServiceService"));
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            DefectService defectService = this.defectServiceService.getDefectServicePort();
            this.attachAuthenticationHandler((BindingProvider)defectService);
            DefectService defectService2 = defectService;
            return defectService2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void attachAuthenticationHandler(BindingProvider service) {
        service.getBinding().setHandlerChain(Arrays.asList(new ClientAuthenticationHandlerWSS(this.user, this.password)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationService getConfigurationService() throws IOException {
        CIMInstance cIMInstance = this;
        synchronized (cIMInstance) {
            if (this.configurationServiceService == null) {
                this.configurationServiceService = new ConfigurationServiceService(new URL(this.getURL(), CONFIGURATION_SERVICE_V5_WSDL), new QName(COVERITY_V5_NAMESPACE, "ConfigurationServiceService"));
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            ConfigurationService configurationService = this.configurationServiceService.getConfigurationServicePort();
            this.attachAuthenticationHandler((BindingProvider)configurationService);
            ConfigurationService configurationService2 = configurationService;
            return configurationService2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public List<MergedDefectDataObj> getDefects(String streamId, List<Long> defectIds) throws IOException, CovRemoteServiceException_Exception {
        MergedDefectFilterSpecDataObj filterSpec1 = new MergedDefectFilterSpecDataObj();
        StreamIdDataObj stream = new StreamIdDataObj();
        stream.setName(streamId);
        PageSpecDataObj pageSpec = new PageSpecDataObj();
        pageSpec.setPageSize(2500);
        ArrayList<MergedDefectDataObj> result = new ArrayList<MergedDefectDataObj>();
        int defectCount = 0;
        MergedDefectsPageDataObj defects = null;
        do {
            pageSpec.setStartIndex(defectCount);
            defects = this.getDefectService().getMergedDefectsForStreams(Arrays.asList(stream), filterSpec1, pageSpec);
            for (MergedDefectDataObj defect : defects.getMergedDefects()) {
                if (!defectIds.contains(defect.getCid())) continue;
                result.add(defect);
            }
        } while ((defectCount += defects.getMergedDefects().size()) < defects.getTotalNumberOfRecords());
        return result;
    }

    public ProjectDataObj getProject(String projectId) throws IOException, CovRemoteServiceException_Exception {
        ProjectFilterSpecDataObj filterSpec = new ProjectFilterSpecDataObj();
        filterSpec.setNamePattern(projectId);
        List projects = this.getConfigurationService().getProjects(filterSpec);
        if (projects.size() == 0) {
            return null;
        }
        return (ProjectDataObj)projects.get(0);
    }

    public Long getProjectKey(String projectId) throws IOException, CovRemoteServiceException_Exception {
        Long result;
        if (this.projectKeys == null) {
            this.projectKeys = new ConcurrentHashMap();
        }
        if ((result = (Long)this.projectKeys.get(projectId)) == null) {
            result = this.getProject(projectId).getProjectKey();
            this.projectKeys.put(projectId, result);
        }
        return result;
    }

    public List<ProjectDataObj> getProjects() throws IOException, CovRemoteServiceException_Exception {
        return this.getConfigurationService().getProjects(new ProjectFilterSpecDataObj());
    }

    public List<StreamDataObj> getStaticStreams(String projectId) throws IOException, CovRemoteServiceException_Exception {
        ProjectDataObj project = this.getProject(projectId);
        ArrayList<StreamDataObj> result = new ArrayList<StreamDataObj>();
        for (StreamDataObj stream : project.getStreams()) {
            if (stream.getId().getName().matches(STREAM_NAME_IGNORE_PATTERN)) continue;
            result.add(stream);
        }
        return result;
    }

    public StreamDataObj getStream(String streamId) throws IOException, CovRemoteServiceException_Exception {
        StreamFilterSpecDataObj filter = new StreamFilterSpecDataObj();
        filter.setNamePattern(streamId);
        List streams = this.getConfigurationService().getStreams(filter);
        if (streams.isEmpty()) {
            return null;
        }
        return (StreamDataObj)streams.get(0);
    }

    public FormValidation doCheck() throws IOException {
        try {
            URL url = this.getURL();
            int responseCode = this.getURLResponseCode(new URL(url, CONFIGURATION_SERVICE_V5_WSDL));
            if (responseCode != 200) {
                return FormValidation.error((String)"Connected successfully, but Coverity web services were not detected.");
            }
            this.getConfigurationService().getServerTime();
            return FormValidation.ok((String)"Successfully connected to the instance.");
        }
        catch (UnknownHostException e) {
            return FormValidation.error((String)"Host name unknown");
        }
        catch (ConnectException e) {
            return FormValidation.error((String)"Connection refused");
        }
        catch (SocketException e) {
            return FormValidation.error((String)"Error connecting to CIM. Please check your connection settings.");
        }
        catch (Throwable e) {
            int patch;
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.6.0_") && (patch = Integer.parseInt(javaVersion.substring(javaVersion.indexOf(95) + 1))) < 26) {
                return FormValidation.error((Throwable)e, (String)"Please use Java 1.6.0_26 or later to run Jenkins.");
            }
            return FormValidation.error((Throwable)e, (String)"An unexpected error occurred.");
        }
    }

    private FormValidation error(Throwable t) {
        if (Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.error((Throwable)t, (String)t.getMessage());
        }
        return FormValidation.error((String)t.getMessage());
    }

    private int getURLResponseCode(URL url) throws IOException {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.connect();
            conn.getInputStream();
            return conn.getResponseCode();
        }
        catch (FileNotFoundException e) {
            return 404;
        }
    }
}

