/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import java.util.logging.Logger;
import jenkins.plugins.coverity.DefectFilters;
import jenkins.plugins.coverity.InvocationAssistance;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMStream
extends AbstractDescribableImpl<CIMStream> {
    private static final Logger logger = Logger.getLogger(CIMStream.class.getName());
    private final String instance;
    private final String project;
    private final String stream;
    private final String id;
    private final DefectFilters defectFilters;
    private final InvocationAssistance invocationAssistanceOverride;

    @DataBoundConstructor
    public CIMStream(String instance, String project, String stream, DefectFilters defectFilters, String id, InvocationAssistance invocationAssistanceOverride) {
        this.instance = Util.fixEmpty((String)instance);
        this.project = Util.fixEmpty((String)project);
        this.stream = Util.fixEmpty((String)stream);
        this.id = Util.fixEmpty((String)id);
        this.defectFilters = defectFilters;
        this.invocationAssistanceOverride = invocationAssistanceOverride;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getProject() {
        return this.project;
    }

    public String getStream() {
        return this.stream;
    }

    public String getId() {
        return this.id;
    }

    public DefectFilters getDefectFilters() {
        return this.defectFilters;
    }

    public InvocationAssistance getInvocationAssistanceOverride() {
        return this.invocationAssistanceOverride;
    }

    public String toString() {
        return "CIMStream{instance='" + this.instance + '\'' + ", project='" + this.project + '\'' + ", stream='" + this.stream + '\'' + ", id='" + this.id + '\'' + ", defectFilters=" + this.defectFilters + ", invocationAssistanceOverride=" + this.invocationAssistanceOverride + '}';
    }

    public boolean isValid() {
        return this.instance != null && this.project != null && this.stream != null;
    }
}

