/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v5.CovRemoteServiceException_Exception;
import com.coverity.ws.v5.MergedDefectDataObj;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Hudson;
import java.io.IOException;
import java.util.List;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverityBuildAction
implements Action {
    private final AbstractBuild build;
    private final List<Long> defectIds;
    private final String projectId;
    private final String streamId;
    private final String cimInstance;
    private String url;

    public CoverityBuildAction(AbstractBuild build, String projectId, String streamId, String cimInstance, List<Long> matchingDefects) {
        this.build = build;
        this.projectId = projectId;
        this.streamId = streamId;
        this.cimInstance = cimInstance;
        this.defectIds = matchingDefects;
    }

    public AbstractBuild getBuild() {
        return this.build;
    }

    public List<Long> getDefectIds() {
        return this.defectIds;
    }

    public List<MergedDefectDataObj> getDefects() throws IOException, CovRemoteServiceException_Exception {
        CIMInstance cim = ((CoverityPublisher.DescriptorImpl)Hudson.getInstance().getDescriptorByType(CoverityPublisher.DescriptorImpl.class)).getInstance(this.cimInstance);
        return cim.getDefects(this.streamId, this.defectIds);
    }

    public String getURL(MergedDefectDataObj defect) throws IOException, CovRemoteServiceException_Exception {
        CIMInstance instance = ((CoverityPublisher.DescriptorImpl)Hudson.getInstance().getDescriptorByType(CoverityPublisher.DescriptorImpl.class)).getInstance(this.cimInstance);
        return String.format("http://%s:%d/sourcebrowser.htm?projectId=%s#mergedDefectId=%d", instance.getHost(), instance.getPort(), instance.getProjectKey(this.projectId), defect.getCid());
    }

    public String getIconFileName() {
        return "/plugin/coverity/icons/coverity-logo-400px.png";
    }

    public String getDisplayName() {
        return "Coverity Defects (" + this.getId() + ")";
    }

    public String getUrlName() {
        return "coverity_" + this.getId();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUrl() {
        return this.build.getUrl() + this.getUrlName();
    }

    public String getId() {
        return this.cimInstance + "_" + this.projectId + "_" + this.streamId;
    }
}

