/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v5.CovRemoteServiceException_Exception;
import com.coverity.ws.v5.StreamDataObj;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityLauncherDecorator;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.InvocationAssistance;

@Extension
public class CoverityLauncherDecorator
extends LauncherDecorator {
    private static final Logger logger = Logger.getLogger(CoverityLauncherDecorator.class.getName());
    public static ThreadLocal<Boolean> SKIP = new /* Unavailable Anonymous Inner Class!! */;

    public Launcher decorate(Launcher launcher, Node node) {
        String[] blacklist;
        String blacklistTemp;
        FilePath temp;
        Executor executor = Executor.currentExecutor();
        if (executor == null) {
            return launcher;
        }
        Queue.Executable exec = executor.getCurrentExecutable();
        if (!(exec instanceof AbstractBuild)) {
            return launcher;
        }
        AbstractBuild build = (AbstractBuild)exec;
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        if (publisher == null) {
            return launcher;
        }
        InvocationAssistance ii = publisher.getInvocationAssistance();
        if (ii == null) {
            return launcher;
        }
        try {
            if (ii.getIntermediateDir() == null) {
                FilePath coverityDir = node.getRootPath().child("coverity");
                coverityDir.mkdirs();
                temp = coverityDir.createTempDir("temp-", null);
            } else {
                temp = new FilePath(node.getChannel(), ii.getIntermediateDir());
                temp.mkdirs();
            }
            build.addAction((Action)new CoverityTempDir(temp, ii.getIntermediateDir() == null));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating temporary directory for Coverity", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while creating temporary directory for Coverity");
        }
        boolean onlyCS = true;
        for (CIMStream cs : publisher.getCimStreams()) {
            CIMInstance cim = publisher.getDescriptor().getInstance(cs.getInstance());
            String id = cs.getInstance() + "/" + cs.getStream();
            try {
                StreamDataObj stream = cim.getStream(cs.getStream());
                if (stream == null) {
                    throw new RuntimeException("Could not find stream: " + id);
                }
                String language = stream.getLanguage();
                if ("CSHARP".equals(language)) continue;
                onlyCS = false;
                break;
            }
            catch (CovRemoteServiceException_Exception e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
        }
        if (publisher.getCimInstance() != null) {
            CIMInstance cim = publisher.getDescriptor().getInstance(publisher.getCimInstance());
            String id = publisher.getCimInstance() + "/" + publisher.getStream();
            try {
                StreamDataObj stream = cim.getStream(publisher.getStream());
                if (stream == null) {
                    throw new RuntimeException("Could not find stream: " + id);
                }
                String language = stream.getLanguage();
                if (!"CSHARP".equals(language)) {
                    onlyCS = false;
                }
            }
            catch (CovRemoteServiceException_Exception e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
        }
        if (onlyCS) {
            logger.info("Only streams of type CSHARP were found, skipping cov-build");
            return launcher;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("cov-build-placeholder");
        args.add("--dir");
        args.add(temp.getRemote());
        if (ii.getBuildArguments() != null) {
            for (String arg : Util.tokenize((String)ii.getBuildArguments())) {
                args.add(arg);
            }
        }
        if ((blacklistTemp = ii.getCovBuildBlacklist()) != null) {
            blacklist = blacklistTemp.split(",");
            for (int i = 0; i < blacklist.length; ++i) {
                blacklist[i] = blacklist[i].trim();
            }
        } else {
            blacklist = new String[]{};
        }
        return new DecoratedLauncher(this, launcher, blacklist, node, args.toArray(new String[args.size()]));
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

