/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v5.CovRemoteServiceException_Exception;
import com.coverity.ws.v5.DefectService;
import com.coverity.ws.v5.MergedDefectDataObj;
import com.coverity.ws.v5.MergedDefectFilterSpecDataObj;
import com.coverity.ws.v5.PageSpecDataObj;
import com.coverity.ws.v5.SnapshotIdDataObj;
import com.coverity.ws.v5.StreamIdDataObj;
import com.coverity.ws.v5.StreamSnapshotFilterSpecDataObj;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityBuildAction;
import jenkins.plugins.coverity.CoverityInstallation;
import jenkins.plugins.coverity.CoverityLauncherDecorator;
import jenkins.plugins.coverity.CoverityMailSender;
import jenkins.plugins.coverity.CoverityProjectAction;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.DefectFilters;
import jenkins.plugins.coverity.InvocationAssistance;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class CoverityPublisher
extends Recorder {
    private static final Logger logger = Logger.getLogger(CoverityPublisher.class.getName());
    private transient String cimInstance;
    private transient String project;
    private transient String stream;
    private transient DefectFilters defectFilters;
    private List<CIMStream> cimStreams;
    private final InvocationAssistance invocationAssistance;
    private final boolean failBuild;
    private final boolean keepIntDir;
    private final boolean skipFetchingDefects;
    private final boolean hideChart;
    private final CoverityMailSender mailSender;

    @DataBoundConstructor
    public CoverityPublisher(List<CIMStream> cimStreams, InvocationAssistance invocationAssistance, boolean failBuild, boolean keepIntDir, boolean skipFetchingDefects, boolean hideChart, CoverityMailSender mailSender, String cimInstance, String project, String stream, DefectFilters defectFilters) {
        this.cimStreams = cimStreams;
        this.invocationAssistance = invocationAssistance;
        this.failBuild = failBuild;
        this.mailSender = mailSender;
        this.keepIntDir = keepIntDir;
        this.skipFetchingDefects = skipFetchingDefects;
        this.hideChart = hideChart;
        this.cimInstance = cimInstance;
        this.project = project;
        this.stream = stream;
        this.defectFilters = defectFilters;
        if (this.isOldDataPresent()) {
            logger.info("Old data format detected. Converting to new format.");
            this.convertOldData();
        }
    }

    private void convertOldData() {
        CIMStream newcs = new CIMStream(this.cimInstance, this.project, this.stream, this.defectFilters, null, null);
        this.cimInstance = null;
        this.project = null;
        this.stream = null;
        this.defectFilters = null;
        if (this.cimStreams == null) {
            this.cimStreams = new ArrayList();
        }
        this.cimStreams.add(newcs);
        this.trimInvalidStreams();
    }

    private boolean isOldDataPresent() {
        return this.cimInstance != null || this.project != null || this.stream != null || this.defectFilters != null;
    }

    private void trimInvalidStreams() {
        Iterator i = this.getCimStreams().iterator();
        while (i.hasNext()) {
            CIMStream cs = (CIMStream)i.next();
            if (!cs.isValid()) {
                i.remove();
                continue;
            }
            if (!cs.getInstance().equals("null") || !cs.getProject().equals("null") || !cs.getStream().equals("null")) continue;
            i.remove();
        }
        LinkedHashSet temp = new LinkedHashSet();
        temp.addAll(this.cimStreams);
        this.cimStreams.clear();
        this.cimStreams.addAll(temp);
    }

    public String getCimInstance() {
        return this.cimInstance;
    }

    public String getProject() {
        return this.project;
    }

    public String getStream() {
        return this.stream;
    }

    public DefectFilters getDefectFilters() {
        return this.defectFilters;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public InvocationAssistance getInvocationAssistance() {
        return this.invocationAssistance;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public boolean isKeepIntDir() {
        return this.keepIntDir;
    }

    public boolean isSkipFetchingDefects() {
        return this.skipFetchingDefects;
    }

    public boolean isHideChart() {
        return this.hideChart;
    }

    public CoverityMailSender getMailSender() {
        return this.mailSender;
    }

    public List<CIMStream> getCimStreams() {
        if (this.cimStreams == null) {
            return new ArrayList<CIMStream>();
        }
        return this.cimStreams;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return this.hideChart ? super.getProjectAction(project) : new CoverityProjectAction(project);
    }

    public static File[] listFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection files = CoverityPublisher.listFiles((File)directory, (FilenameFilter)filter, (boolean)recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        Vector<File> files = new Vector<File>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(CoverityPublisher.listFiles((File)entry, (FilenameFilter)filter, (boolean)recurse));
        }
        return files;
    }

    public File[] findAssemblies(String dirName) {
        File dir = new File(dirName);
        return CoverityPublisher.listFilesAsArray((File)dir, (FilenameFilter)new /* Unavailable Anonymous Inner Class!! */, (boolean)true);
    }

    public File[] findMsvscaOutputFiles(String dirName) {
        File dir = new File(dirName);
        return CoverityPublisher.listFilesAsArray((File)dir, (FilenameFilter)new /* Unavailable Anonymous Inner Class!! */, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        int i$;
        InvocationAssistance effectiveIA;
        String language;
        CIMInstance cim;
        String javaWarFile;
        if (this.isOldDataPresent()) {
            logger.info("Old data format detected. Converting to new format.");
            this.convertOldData();
        }
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        CoverityTempDir temp = (CoverityTempDir)build.getAction(CoverityTempDir.class);
        Node node = Executor.currentExecutor().getOwner().getNode();
        String home = this.getDescriptor().getHome(node, build.getEnvironment((TaskListener)listener));
        if (this.invocationAssistance != null && this.invocationAssistance.getSaOverride() != null) {
            home = new CoverityInstallation(this.invocationAssistance.getSaOverride()).forEnvironment(build.getEnvironment((TaskListener)listener)).getHome();
        }
        String string = javaWarFile = this.invocationAssistance != null ? this.invocationAssistance.getJavaWarFile() : null;
        if (javaWarFile != null) {
            listener.getLogger().println("[Coverity] Specified WAR file '" + javaWarFile + "' in config");
            String covEmitJava = "cov-emit-java";
            covEmitJava = new FilePath(launcher.getChannel(), home).child("bin").child(covEmitJava).getRemote();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(covEmitJava);
            cmd.add("--dir");
            cmd.add(temp.tempDir.getRemote());
            cmd.add("--webapp-archive");
            cmd.add(javaWarFile);
            try {
                CoverityLauncherDecorator.SKIP.set(true);
                int result = launcher.launch().cmds(new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]))).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
                if (result != 0) {
                    listener.getLogger().println("[Coverity] " + covEmitJava + " returned " + result + ", aborting...");
                    build.setResult(Result.FAILURE);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                CoverityLauncherDecorator.SKIP.set(false);
            }
        }
        HashSet<String> analyzedLanguages = new HashSet<String>();
        for (CIMStream cimStream : this.getCimStreams()) {
            cim = this.getDescriptor().getInstance(cimStream.getInstance());
            language = null;
            try {
                language = this.getLanguage(cimStream);
            }
            catch (CovRemoteServiceException_Exception e) {
                e.printStackTrace(listener.error("Error while retrieving stream information for " + cimStream.getStream()));
                return false;
            }
            if (this.invocationAssistance == null) continue;
            effectiveIA = this.invocationAssistance;
            if (cimStream.getInvocationAssistanceOverride() != null) {
                effectiveIA = this.invocationAssistance.merge(cimStream.getInvocationAssistanceOverride());
            }
            try {
                if ("CSHARP".equals(language) && effectiveIA.getCsharpAssemblies() != null) {
                    String csharpAssembliesStr = effectiveIA.getCsharpAssemblies();
                    listener.getLogger().println("[Coverity] C# Project detected, assemblies to analyze are: " + csharpAssembliesStr);
                }
                String covAnalyze = null;
                covAnalyze = "JAVA".equals(language) ? "cov-analyze-java" : ("CSHARP".equals(language) ? "cov-analyze-cs" : "cov-analyze");
                if (home != null) {
                    covAnalyze = new FilePath(launcher.getChannel(), home).child("bin").child(covAnalyze).getRemote();
                }
                CoverityLauncherDecorator.SKIP.set(true);
                if (!analyzedLanguages.contains(language)) {
                    boolean csharpAutomaticAssemblies;
                    String csharpAssemblies;
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add(covAnalyze);
                    cmd.add("--dir");
                    cmd.add(temp.tempDir.getRemote());
                    if ("CSHARP".equals(language) && (csharpAssemblies = effectiveIA.getCsharpAssemblies()) != null) {
                        cmd.add(csharpAssemblies);
                    }
                    if (csharpAutomaticAssemblies = this.invocationAssistance.getCsharpAutomaticAssemblies()) {
                        File[] automaticAssemblies;
                        listener.getLogger().println("[Coverity] Searching for C# assemblies...");
                        for (File assembly : automaticAssemblies = this.findAssemblies(build.getWorkspace().getRemote())) {
                            cmd.add(assembly.getAbsolutePath());
                        }
                    }
                    listener.getLogger().println("[Coverity] cmd so far is: " + ((Object)cmd).toString());
                    if (effectiveIA.getAnalyzeArguments() != null) {
                        String[] arr$ = Util.tokenize((String)effectiveIA.getAnalyzeArguments());
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; i$ += 1) {
                            String arg = arr$[i$];
                            cmd.add(arg);
                        }
                    }
                    int result = launcher.launch().cmds(new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]))).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
                    analyzedLanguages.add(language);
                    if (result == 0) continue;
                    listener.getLogger().println("[Coverity] " + covAnalyze + " returned " + result + ", aborting...");
                    build.setResult(Result.FAILURE);
                    boolean len$ = false;
                    return len$;
                }
                listener.getLogger().println("Skipping analysis, because language " + language + " has already been analyzed");
            }
            finally {
                CoverityLauncherDecorator.SKIP.set(false);
            }
        }
        if (this.invocationAssistance != null) {
            boolean csharpMsvsca = this.invocationAssistance.getCsharpMsvsca();
            String csharpMsvscaOutputFiles = this.invocationAssistance.getCsharpMsvscaOutputFiles();
            if (analyzedLanguages.contains("CSHARP") && (csharpMsvsca || csharpMsvscaOutputFiles != null)) {
                String covImportMsvsca = "cov-import-msvsca";
                covImportMsvsca = new FilePath(launcher.getChannel(), home).child("bin").child(covImportMsvsca).getRemote();
                ArrayList<String> importCmd = new ArrayList<String>();
                importCmd.add(covImportMsvsca);
                importCmd.add("--dir");
                importCmd.add(temp.tempDir.getRemote());
                importCmd.add("--append");
                listener.getLogger().println("[Coverity] Searching for Microsoft Code Analysis results...");
                File[] msvscaOutputFiles = new File[]{};
                if (csharpMsvsca) {
                    msvscaOutputFiles = this.findMsvscaOutputFiles(build.getWorkspace().getRemote());
                }
                for (File outputFile : msvscaOutputFiles) {
                    importCmd.add(outputFile.getAbsolutePath());
                }
                if (csharpMsvscaOutputFiles != null && csharpMsvscaOutputFiles.length() > 0) {
                    importCmd.add(csharpMsvscaOutputFiles);
                }
                if (msvscaOutputFiles.length == 0 && (csharpMsvscaOutputFiles == null || csharpMsvscaOutputFiles.length() == 0)) {
                    listener.getLogger().println("[MSVSCA] MSVSCA No results found, skipping");
                } else {
                    listener.getLogger().println("[MSVSCA] MSVSCA Import cmd so far is: " + ((Object)importCmd).toString());
                    int importResult = launcher.launch().cmds(new ArgumentListBuilder(importCmd.toArray(new String[importCmd.size()]))).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
                    if (importResult != 0) {
                        listener.getLogger().println("[Coverity] " + covImportMsvsca + " returned " + importResult + ", aborting...");
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                }
            }
        }
        for (CIMStream cimStream : this.getCimStreams()) {
            cim = this.getDescriptor().getInstance(cimStream.getInstance());
            language = null;
            try {
                language = this.getLanguage(cimStream);
            }
            catch (CovRemoteServiceException_Exception e) {
                e.printStackTrace(listener.error("Error while retrieving stream information for " + cimStream.getStream()));
                return false;
            }
            if (this.invocationAssistance == null) continue;
            effectiveIA = this.invocationAssistance;
            if (cimStream.getInvocationAssistanceOverride() != null) {
                effectiveIA = this.invocationAssistance.merge(cimStream.getInvocationAssistanceOverride());
            }
            try {
                if ("CSHARP".equals(language) && effectiveIA.getCsharpAssemblies() != null) {
                    String csharpAssembliesStr = effectiveIA.getCsharpAssemblies();
                    listener.getLogger().println("[Coverity] C# Project detected, assemblies to analyze are: " + csharpAssembliesStr);
                }
                String covCommitDefects = "cov-commit-defects";
                if (home != null) {
                    covCommitDefects = new FilePath(launcher.getChannel(), home).child("bin").child(covCommitDefects).getRemote();
                }
                CoverityLauncherDecorator.SKIP.set(true);
                boolean useDataPort = cim.getDataPort() != 0;
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(covCommitDefects);
                cmd.add("--dir");
                cmd.add(temp.tempDir.getRemote());
                cmd.add("--host");
                cmd.add(cim.getHost());
                cmd.add(useDataPort ? "--dataport" : "--port");
                cmd.add(useDataPort ? Integer.toString(cim.getDataPort()) : Integer.toString(cim.getPort()));
                cmd.add("--stream");
                cmd.add(cimStream.getStream());
                cmd.add("--user");
                cmd.add(cim.getUser());
                if (effectiveIA.getCommitArguments() != null) {
                    for (String arg : Util.tokenize((String)effectiveIA.getCommitArguments())) {
                        cmd.add(arg);
                    }
                }
                ArgumentListBuilder args = new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]));
                int result = launcher.launch().cmds(args).envs(Collections.singletonMap("COVERITY_PASSPHRASE", cim.getPassword())).stdout((TaskListener)listener).stderr((OutputStream)listener.getLogger()).join();
                if (result == 0) continue;
                listener.getLogger().println("[Coverity] cov-commit-defects returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                i$ = 0;
                return i$ != 0;
            }
            finally {
                CoverityLauncherDecorator.SKIP.set(false);
            }
        }
        if (temp != null) {
            if (!this.keepIntDir || temp.def) {
                listener.getLogger().println("[Coverity] deleting intermediate directory");
                temp.tempDir.deleteRecursive();
            } else {
                listener.getLogger().println("[Coverity] preserving intermediate directory: " + temp.tempDir);
            }
        }
        Pattern snapshotPattern = Pattern.compile(".*New snapshot ID (\\d*) added.");
        BufferedReader reader = new BufferedReader(build.getLogReader());
        String line = null;
        ArrayList<Long> snapshotIds = new ArrayList<Long>();
        try {
            while ((line = reader.readLine()) != null) {
                Matcher m = snapshotPattern.matcher(line);
                if (!m.matches()) continue;
                snapshotIds.add(Long.parseLong(m.group(1)));
            }
        }
        finally {
            reader.close();
        }
        if (snapshotIds.size() != this.getCimStreams().size()) {
            listener.getLogger().println("[Coverity] Wrong number of snapshot IDs found in build log");
            build.setResult(Result.FAILURE);
            return false;
        }
        listener.getLogger().println("[Coverity] Found snapshot IDs " + snapshotIds);
        if (!this.skipFetchingDefects) {
            for (int i = 0; i < this.cimStreams.size(); ++i) {
                CIMStream cimStream = (CIMStream)this.cimStreams.get(i);
                long snapshotId = (Long)snapshotIds.get(i);
                try {
                    String rootUrl;
                    CIMInstance cim2 = this.getDescriptor().getInstance(cimStream.getInstance());
                    listener.getLogger().println("[Coverity] Fetching defects for stream " + cimStream.getStream());
                    List defects = this.getDefectsForSnapshot(cimStream, snapshotId);
                    listener.getLogger().println("[Coverity] Found " + defects.size() + " defects");
                    HashSet<String> checkers = new HashSet<String>();
                    for (MergedDefectDataObj defect : defects) {
                        checkers.add(defect.getCheckerName());
                    }
                    this.getDescriptor().updateCheckers(this.getLanguage(cimStream), checkers);
                    ArrayList<Long> matchingDefects = new ArrayList<Long>();
                    for (MergedDefectDataObj defect : defects) {
                        if (cimStream.getDefectFilters() == null) {
                            matchingDefects.add(defect.getCid());
                            continue;
                        }
                        boolean match = cimStream.getDefectFilters().matches(defect);
                        if (!match) continue;
                        matchingDefects.add(defect.getCid());
                    }
                    if (!matchingDefects.isEmpty()) {
                        listener.getLogger().println("[Coverity] Found " + matchingDefects.size() + " defects matching all filters: " + matchingDefects);
                        if (this.failBuild && build.getResult().isBetterThan(Result.FAILURE)) {
                            build.setResult(Result.FAILURE);
                        }
                    } else {
                        listener.getLogger().println("[Coverity] No defects matched all filters.");
                    }
                    CoverityBuildAction action = new CoverityBuildAction(build, cimStream.getProject(), cimStream.getStream(), cimStream.getInstance(), matchingDefects);
                    build.addAction((Action)action);
                    if (!matchingDefects.isEmpty() && this.mailSender != null) {
                        this.mailSender.execute(action, listener);
                    }
                    if ((rootUrl = Hudson.getInstance().getRootUrl()) == null) continue;
                    listener.getLogger().println("Coverity details: " + Hudson.getInstance().getRootUrl() + build.getUrl() + action.getUrlName());
                    continue;
                }
                catch (CovRemoteServiceException_Exception e) {
                    e.printStackTrace(listener.error("[Coverity] An error occurred while fetching defects"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
        }
        return true;
    }

    public List<MergedDefectDataObj> getDefectsForSnapshot(CIMStream cimStream, long snapshotId) throws IOException, CovRemoteServiceException_Exception {
        CIMInstance cim = this.getDescriptor().getInstance(cimStream.getInstance());
        DefectService ds = cim.getDefectService();
        PageSpecDataObj pageSpec = new PageSpecDataObj();
        pageSpec.setPageSize(1000);
        pageSpec.setSortAscending(true);
        StreamIdDataObj streamId = new StreamIdDataObj();
        streamId.setName(cimStream.getStream());
        MergedDefectFilterSpecDataObj filter = new MergedDefectFilterSpecDataObj();
        StreamSnapshotFilterSpecDataObj sfilter = new StreamSnapshotFilterSpecDataObj();
        SnapshotIdDataObj snapid = new SnapshotIdDataObj();
        snapid.setId(snapshotId);
        sfilter.setStreamId(streamId);
        sfilter.getSnapshotIdIncludeList().add(snapid);
        filter.getStreamSnapshotFilterSpecIncludeList().add(sfilter);
        return ds.getMergedDefectsForStreams(Arrays.asList(streamId), filter, pageSpec).getMergedDefects();
    }

    public String getLanguage(CIMStream cimStream) throws IOException, CovRemoteServiceException_Exception {
        return this.getDescriptor().getInstance(cimStream.getInstance()).getStream(cimStream.getStream()).getLanguage();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

