/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v5.AttributeDefinitionDataObj;
import com.coverity.ws.v5.AttributeDefinitionIdDataObj;
import com.coverity.ws.v5.AttributeValueDataObj;
import com.coverity.ws.v5.ComponentDataObj;
import com.coverity.ws.v5.ComponentMapDataObj;
import com.coverity.ws.v5.ComponentMapFilterSpecDataObj;
import com.coverity.ws.v5.CovRemoteServiceException_Exception;
import com.coverity.ws.v5.ProjectDataObj;
import com.coverity.ws.v5.StreamDataObj;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.DefectFilters;
import jenkins.plugins.coverity.InvocationAssistance;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMStream
extends AbstractDescribableImpl<CIMStream> {
    private static final Logger logger = Logger.getLogger(CIMStream.class.getName());
    private final String instance;
    private final String project;
    private final String stream;
    private final String id;
    private final DefectFilters defectFilters;
    private final InvocationAssistance invocationAssistanceOverride;

    @DataBoundConstructor
    public CIMStream(String instance, String project, String stream, DefectFilters defectFilters, String id, InvocationAssistance invocationAssistanceOverride) {
        this.instance = Util.fixEmpty((String)instance);
        this.project = Util.fixEmpty((String)project);
        this.stream = Util.fixEmpty((String)stream);
        this.id = Util.fixEmpty((String)id);
        this.defectFilters = defectFilters;
        this.invocationAssistanceOverride = invocationAssistanceOverride;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getProject() {
        return this.project;
    }

    public String getStream() {
        return this.stream;
    }

    public String getId() {
        return this.id;
    }

    public DefectFilters getDefectFilters() {
        return this.defectFilters;
    }

    public InvocationAssistance getInvocationAssistanceOverride() {
        return this.invocationAssistanceOverride;
    }

    public String toString() {
        return "CIMStream{instance='" + this.instance + '\'' + ", project='" + this.project + '\'' + ", stream='" + this.stream + '\'' + ", id='" + this.id + '\'' + ", defectFilters=" + this.defectFilters + ", invocationAssistanceOverride=" + this.invocationAssistanceOverride + '}';
    }

    public boolean isValid() {
        return this.instance != null && this.project != null && this.stream != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<CIMStream> {
        public String getDisplayName() {
            return "";
        }

        public CoverityPublisher.DescriptorImpl getPublisherDescriptor() {
            return (CoverityPublisher.DescriptorImpl)Hudson.getInstance().getDescriptorByType(CoverityPublisher.DescriptorImpl.class);
        }

        public List<CIMInstance> getInstances() {
            return this.getPublisherDescriptor().getInstances();
        }

        public CIMInstance getInstance(String name) {
            for (CIMInstance instance : this.getInstances()) {
                if (!instance.getName().equals(name)) continue;
                return instance;
            }
            return null;
        }

        public String getRandomID() {
            Random r = new Random();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                sb.append("" + r.nextInt(10));
            }
            return sb.toString();
        }

        public String getRandomID(Object o) {
            if (o != null) {
                return "" + o.hashCode();
            }
            return this.getRandomID();
        }

        public ListBoxModel doFillInstanceItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("");
            for (CIMInstance instance : this.getInstances()) {
                result.add(instance.getName());
            }
            return result;
        }

        public ListBoxModel doFillProjectItems(@QueryParameter String instance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            if (!StringUtils.isEmpty((String)instance)) {
                for (ProjectDataObj project : this.getInstance(instance).getProjects()) {
                    ListBoxModel streams = this.doFillStreamItems(instance, project.getId().getName());
                    if (streams.isEmpty()) continue;
                    result.add(project.getId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillStreamItems(@QueryParameter String instance, @QueryParameter String project) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            if (StringUtils.isEmpty((String)project)) {
                return result;
            }
            CIMInstance cimInstance = this.getInstance(instance);
            if (cimInstance != null) {
                for (StreamDataObj stream : cimInstance.getStaticStreams(project)) {
                    if (!"JAVA".equals(stream.getLanguage()) && !"CXX".equals(stream.getLanguage()) && !"CSHARP".equals(stream.getLanguage())) continue;
                    result.add(stream.getId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillClassificationDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                AttributeDefinitionIdDataObj adido = new AttributeDefinitionIdDataObj();
                adido.setName("Classification");
                AttributeDefinitionDataObj addo = this.getInstance(cimInstance).getConfigurationService().getAttribute(adido);
                for (AttributeValueDataObj classification : addo.getConfigurableValues()) {
                    result.add(classification.getAttributeValueId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillActionDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                AttributeDefinitionIdDataObj adido = new AttributeDefinitionIdDataObj();
                adido.setName("Action");
                AttributeDefinitionDataObj addo = this.getInstance(cimInstance).getConfigurationService().getAttribute(adido);
                for (AttributeValueDataObj classification : addo.getConfigurableValues()) {
                    result.add(classification.getAttributeValueId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillSeveritiesDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null) {
                AttributeDefinitionIdDataObj adido = new AttributeDefinitionIdDataObj();
                adido.setName("Severity");
                AttributeDefinitionDataObj addo = this.getInstance(cimInstance).getConfigurationService().getAttribute(adido);
                for (AttributeValueDataObj classification : addo.getConfigurableValues()) {
                    result.add(classification.getAttributeValueId().getName());
                }
            }
            return result;
        }

        public ListBoxModel doFillComponentDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance, @QueryParameter(value="../stream") String streamId) throws IOException, CovRemoteServiceException_Exception {
            ListBoxModel result = new ListBoxModel();
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance != null && !StringUtils.isEmpty((String)streamId)) {
                StreamDataObj stream = instance.getStream(streamId);
                String componentMapId = stream.getComponentMapId().getName();
                ComponentMapFilterSpecDataObj componentMapFilterSpec = new ComponentMapFilterSpecDataObj();
                componentMapFilterSpec.setNamePattern(componentMapId);
                for (ComponentMapDataObj map : instance.getConfigurationService().getComponentMaps(componentMapFilterSpec)) {
                    for (ComponentDataObj component : map.getComponents()) {
                        result.add(component.getComponentId().getName());
                    }
                }
            }
            return result;
        }

        public ListBoxModel doFillCheckerDefectFilterItems(@QueryParameter(value="../cimInstance") String cimInstance, @QueryParameter(value="../stream") String streamId) throws IOException, CovRemoteServiceException_Exception {
            if (StringUtils.isEmpty((String)streamId)) {
                return new ListBoxModel();
            }
            CIMInstance instance = this.getInstance(cimInstance);
            if (instance == null) {
                return new ListBoxModel();
            }
            StreamDataObj stream = instance.getStream(streamId);
            String type = stream.getLanguage();
            if ("CXX".equals(type)) {
                return this.getPublisherDescriptor().split(this.getPublisherDescriptor().getCxxCheckers());
            }
            if ("JAVA".equals(type)) {
                return this.getPublisherDescriptor().split(this.getPublisherDescriptor().getJavaCheckers());
            }
            if ("CSHARP".equals(type)) {
                return this.getPublisherDescriptor().split(this.getPublisherDescriptor().getCsharpCheckers());
            }
            return new ListBoxModel();
        }
    }
}

