/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v5.CovRemoteServiceException_Exception;
import com.coverity.ws.v5.StreamDataObj;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityInstallation;
import jenkins.plugins.coverity.CoverityPublisher;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.InvocationAssistance;

@Extension
public class CoverityLauncherDecorator
extends LauncherDecorator {
    private static final Logger logger = Logger.getLogger(CoverityLauncherDecorator.class.getName());
    public static ThreadLocal<Boolean> SKIP = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public Launcher decorate(Launcher launcher, Node node) {
        String[] blacklist;
        String blacklistTemp;
        FilePath temp;
        Executor executor = Executor.currentExecutor();
        if (executor == null) {
            return launcher;
        }
        Queue.Executable exec = executor.getCurrentExecutable();
        if (!(exec instanceof AbstractBuild)) {
            return launcher;
        }
        AbstractBuild build = (AbstractBuild)exec;
        AbstractProject project = build.getProject();
        CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
        if (publisher == null) {
            return launcher;
        }
        InvocationAssistance ii = publisher.getInvocationAssistance();
        if (ii == null) {
            return launcher;
        }
        try {
            if (ii.getIntermediateDir() == null) {
                FilePath coverityDir = node.getRootPath().child("coverity");
                coverityDir.mkdirs();
                temp = coverityDir.createTempDir("temp-", null);
            } else {
                temp = new FilePath(node.getChannel(), ii.getIntermediateDir());
                temp.mkdirs();
            }
            build.addAction((Action)new CoverityTempDir(temp, ii.getIntermediateDir() == null));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating temporary directory for Coverity", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while creating temporary directory for Coverity");
        }
        boolean onlyCS = true;
        for (CIMStream cs : publisher.getCimStreams()) {
            CIMInstance cim = publisher.getDescriptor().getInstance(cs.getInstance());
            String id = cs.getInstance() + "/" + cs.getStream();
            try {
                StreamDataObj stream = cim.getStream(cs.getStream());
                if (stream == null) {
                    throw new RuntimeException("Could not find stream: " + id);
                }
                String language = stream.getLanguage();
                if ("CSHARP".equals(language)) continue;
                onlyCS = false;
                break;
            }
            catch (CovRemoteServiceException_Exception e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
        }
        if (publisher.getCimInstance() != null) {
            CIMInstance cim = publisher.getDescriptor().getInstance(publisher.getCimInstance());
            String id = publisher.getCimInstance() + "/" + publisher.getStream();
            try {
                StreamDataObj stream = cim.getStream(publisher.getStream());
                if (stream == null) {
                    throw new RuntimeException("Could not find stream: " + id);
                }
                String language = stream.getLanguage();
                if (!"CSHARP".equals(language)) {
                    onlyCS = false;
                }
            }
            catch (CovRemoteServiceException_Exception e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while retrieving stream information for instance/stream: " + id, e);
            }
        }
        if (onlyCS) {
            logger.info("Only streams of type CSHARP were found, skipping cov-build");
            return launcher;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("cov-build-placeholder");
        args.add("--dir");
        args.add(temp.getRemote());
        if (ii.getBuildArguments() != null) {
            for (String arg : Util.tokenize((String)ii.getBuildArguments())) {
                args.add(arg);
            }
        }
        if ((blacklistTemp = ii.getCovBuildBlacklist()) != null) {
            blacklist = blacklistTemp.split(",");
            for (int i = 0; i < blacklist.length; ++i) {
                blacklist[i] = blacklist[i].trim();
            }
        } else {
            blacklist = new String[]{};
        }
        return new DecoratedLauncher(launcher, blacklist, node, args.toArray(new String[args.size()]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DecoratedLauncher
    extends Launcher {
        private final Launcher decorated;
        private final String[] prefix;
        private final String[] blacklist;
        private final String toolsDir;
        private final Node node;

        public DecoratedLauncher(Launcher decorated, String[] blacklist, Node node, String ... prefix) {
            super(decorated);
            this.decorated = decorated;
            this.prefix = prefix;
            this.blacklist = blacklist;
            this.node = node;
            this.toolsDir = node.getRootPath().child("tools").getRemote();
        }

        private String[] getPrefix() {
            String[] tp = (String[])this.prefix.clone();
            tp[0] = this.getCovBuild();
            return tp;
        }

        public Proc launch(Launcher.ProcStarter starter) throws IOException {
            if (!SKIP.get().booleanValue()) {
                if (this.isBlacklisted((String)starter.cmds().get(0))) {
                    logger.info((String)starter.cmds().get(0) + " is blacklisted, skipping cov-build");
                    return this.decorated.launch(starter);
                }
                List cmds = starter.cmds();
                String lastArg = (String)cmds.get(cmds.size() - 1);
                if (lastArg.startsWith(this.toolsDir) && lastArg.endsWith(".sh")) {
                    logger.info(lastArg + " is a tools script, skipping cov-build");
                    return this.decorated.launch(starter);
                }
                cmds.addAll(0, Arrays.asList(this.getPrefix()));
                starter.cmds(cmds);
                boolean[] masks = starter.masks();
                if (masks == null) {
                    masks = new boolean[cmds.size()];
                    starter.masks(masks);
                } else {
                    starter.masks(this.prefix(masks));
                }
            }
            return this.decorated.launch(starter);
        }

        public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
            String lastArg = cmd[cmd.length - 1];
            if (lastArg.startsWith(this.toolsDir) && lastArg.endsWith(".sh")) {
                logger.info(lastArg + " is a tools script, skipping cov-build");
                this.decorated.launchChannel(cmd, out, workDir, envVars);
            }
            return this.decorated.launchChannel(this.prefix(cmd), out, workDir, envVars);
        }

        public boolean isUnix() {
            return this.decorated.isUnix();
        }

        public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
            this.decorated.kill(modelEnvVars);
        }

        private String[] prefix(String[] args) {
            if (this.isBlacklisted(args[0])) {
                return args;
            }
            String[] newArgs = new String[args.length + this.prefix.length];
            System.arraycopy(this.getPrefix(), 0, newArgs, 0, this.prefix.length);
            System.arraycopy(args, 0, newArgs, this.prefix.length, args.length);
            return newArgs;
        }

        private boolean[] prefix(boolean[] args) {
            boolean[] newArgs = new boolean[args.length + this.prefix.length];
            System.arraycopy(args, 0, newArgs, this.prefix.length, args.length);
            return newArgs;
        }

        private boolean isBlacklisted(String cmd) {
            for (String s : this.blacklist) {
                if (!s.equals(cmd)) continue;
                return true;
            }
            return false;
        }

        private String getCovBuild() {
            Executor executor = Executor.currentExecutor();
            Queue.Executable exec = executor.getCurrentExecutable();
            AbstractBuild build = (AbstractBuild)exec;
            AbstractProject project = build.getProject();
            CoverityPublisher publisher = (CoverityPublisher)project.getPublishersList().get(CoverityPublisher.class);
            InvocationAssistance ii = publisher.getInvocationAssistance();
            String covBuild = "cov-build";
            TaskListener listener = this.decorated.getListener();
            String home = null;
            try {
                home = publisher.getDescriptor().getHome(this.node, build.getEnvironment(listener));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (ii.getSaOverride() != null) {
                try {
                    home = new CoverityInstallation(ii.getSaOverride()).forEnvironment(build.getEnvironment(listener)).getHome();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (home != null) {
                covBuild = new FilePath(this.node.getChannel(), home).child("bin").child(covBuild).getRemote();
            }
            return covBuild;
        }
    }
}

