/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import com.coverity.ws.v5.CovRemoteServiceException_Exception;
import com.coverity.ws.v5.DefectService;
import com.coverity.ws.v5.MergedDefectDataObj;
import com.coverity.ws.v5.MergedDefectFilterSpecDataObj;
import com.coverity.ws.v5.PageSpecDataObj;
import com.coverity.ws.v5.SnapshotIdDataObj;
import com.coverity.ws.v5.StreamIdDataObj;
import com.coverity.ws.v5.StreamSnapshotFilterSpecDataObj;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.IOUtils;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.plugins.coverity.CIMInstance;
import jenkins.plugins.coverity.CIMStream;
import jenkins.plugins.coverity.CoverityBuildAction;
import jenkins.plugins.coverity.CoverityInstallation;
import jenkins.plugins.coverity.CoverityLauncherDecorator;
import jenkins.plugins.coverity.CoverityMailSender;
import jenkins.plugins.coverity.CoverityProjectAction;
import jenkins.plugins.coverity.CoverityTempDir;
import jenkins.plugins.coverity.DefectFilters;
import jenkins.plugins.coverity.InvocationAssistance;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverityPublisher
extends Recorder {
    private static final Logger logger = Logger.getLogger(CoverityPublisher.class.getName());
    private transient String cimInstance;
    private transient String project;
    private transient String stream;
    private transient DefectFilters defectFilters;
    private List<CIMStream> cimStreams;
    private final InvocationAssistance invocationAssistance;
    private final boolean failBuild;
    private final boolean keepIntDir;
    private final boolean skipFetchingDefects;
    private final boolean hideChart;
    private final CoverityMailSender mailSender;

    @DataBoundConstructor
    public CoverityPublisher(List<CIMStream> cimStreams, InvocationAssistance invocationAssistance, boolean failBuild, boolean keepIntDir, boolean skipFetchingDefects, boolean hideChart, CoverityMailSender mailSender, String cimInstance, String project, String stream, DefectFilters defectFilters) {
        this.cimStreams = cimStreams;
        this.invocationAssistance = invocationAssistance;
        this.failBuild = failBuild;
        this.mailSender = mailSender;
        this.keepIntDir = keepIntDir;
        this.skipFetchingDefects = skipFetchingDefects;
        this.hideChart = hideChart;
        this.cimInstance = cimInstance;
        this.project = project;
        this.stream = stream;
        this.defectFilters = defectFilters;
        if (this.isOldDataPresent()) {
            logger.info("Old data format detected. Converting to new format.");
            this.convertOldData();
        }
    }

    private void convertOldData() {
        CIMStream newcs = new CIMStream(this.cimInstance, this.project, this.stream, this.defectFilters, null, null);
        this.cimInstance = null;
        this.project = null;
        this.stream = null;
        this.defectFilters = null;
        if (this.cimStreams == null) {
            this.cimStreams = new ArrayList<CIMStream>();
        }
        this.cimStreams.add(newcs);
        this.trimInvalidStreams();
    }

    private boolean isOldDataPresent() {
        return this.cimInstance != null || this.project != null || this.stream != null || this.defectFilters != null;
    }

    private void trimInvalidStreams() {
        Iterator<CIMStream> i = this.getCimStreams().iterator();
        while (i.hasNext()) {
            CIMStream cs = i.next();
            if (!cs.isValid()) {
                i.remove();
                continue;
            }
            if (!cs.getInstance().equals("null") || !cs.getProject().equals("null") || !cs.getStream().equals("null")) continue;
            i.remove();
        }
        LinkedHashSet<CIMStream> temp = new LinkedHashSet<CIMStream>();
        temp.addAll(this.cimStreams);
        this.cimStreams.clear();
        this.cimStreams.addAll(temp);
    }

    public String getCimInstance() {
        return this.cimInstance;
    }

    public String getProject() {
        return this.project;
    }

    public String getStream() {
        return this.stream;
    }

    public DefectFilters getDefectFilters() {
        return this.defectFilters;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public InvocationAssistance getInvocationAssistance() {
        return this.invocationAssistance;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public boolean isKeepIntDir() {
        return this.keepIntDir;
    }

    public boolean isSkipFetchingDefects() {
        return this.skipFetchingDefects;
    }

    public boolean isHideChart() {
        return this.hideChart;
    }

    public CoverityMailSender getMailSender() {
        return this.mailSender;
    }

    public List<CIMStream> getCimStreams() {
        if (this.cimStreams == null) {
            return new ArrayList<CIMStream>();
        }
        return this.cimStreams;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return this.hideChart ? super.getProjectAction(project) : new CoverityProjectAction(project);
    }

    public static File[] listFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = CoverityPublisher.listFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        Vector<File> files = new Vector<File>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(CoverityPublisher.listFiles(entry, filter, recurse));
        }
        return files;
    }

    public File[] findAssemblies(String dirName) {
        File dir = new File(dirName);
        return CoverityPublisher.listFilesAsArray(dir, new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                if (filename.endsWith(".exe") || filename.endsWith(".dll")) {
                    String pathname = dir.getAbsolutePath();
                    pathname = pathname + File.separator + filename;
                    String pdbFilename = pathname.replaceAll(".exe$", ".pdb");
                    pdbFilename = pdbFilename.replaceAll(".dll$", ".pdb");
                    File pdbFile = new File(pdbFilename);
                    return pdbFile.exists();
                }
                return false;
            }
        }, true);
    }

    public File[] findMsvscaOutputFiles(String dirName) {
        File dir = new File(dirName);
        return CoverityPublisher.listFilesAsArray(dir, new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.endsWith("CodeAnalysisLog.xml");
            }
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        int i$;
        InvocationAssistance effectiveIA;
        String language;
        CIMInstance cim;
        String javaWarFile;
        if (this.isOldDataPresent()) {
            logger.info("Old data format detected. Converting to new format.");
            this.convertOldData();
        }
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
            return true;
        }
        CoverityTempDir temp = (CoverityTempDir)build.getAction(CoverityTempDir.class);
        Node node = Executor.currentExecutor().getOwner().getNode();
        String home = this.getDescriptor().getHome(node, build.getEnvironment((TaskListener)listener));
        if (this.invocationAssistance != null && this.invocationAssistance.getSaOverride() != null) {
            home = new CoverityInstallation(this.invocationAssistance.getSaOverride()).forEnvironment(build.getEnvironment((TaskListener)listener)).getHome();
        }
        String string = javaWarFile = this.invocationAssistance != null ? this.invocationAssistance.getJavaWarFile() : null;
        if (javaWarFile != null) {
            listener.getLogger().println("[Coverity] Specified WAR file '" + javaWarFile + "' in config");
            String covEmitJava = "cov-emit-java";
            covEmitJava = new FilePath(launcher.getChannel(), home).child("bin").child(covEmitJava).getRemote();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(covEmitJava);
            cmd.add("--dir");
            cmd.add(temp.tempDir.getRemote());
            cmd.add("--webapp-archive");
            cmd.add(javaWarFile);
            try {
                CoverityLauncherDecorator.SKIP.set(true);
                int result = launcher.launch().cmds(new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]))).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
                if (result != 0) {
                    listener.getLogger().println("[Coverity] " + covEmitJava + " returned " + result + ", aborting...");
                    build.setResult(Result.FAILURE);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                CoverityLauncherDecorator.SKIP.set(false);
            }
        }
        HashSet<String> analyzedLanguages = new HashSet<String>();
        for (CIMStream cimStream : this.getCimStreams()) {
            cim = this.getDescriptor().getInstance(cimStream.getInstance());
            language = null;
            try {
                language = this.getLanguage(cimStream);
            }
            catch (CovRemoteServiceException_Exception e) {
                e.printStackTrace(listener.error("Error while retrieving stream information for " + cimStream.getStream()));
                return false;
            }
            if (this.invocationAssistance == null) continue;
            effectiveIA = this.invocationAssistance;
            if (cimStream.getInvocationAssistanceOverride() != null) {
                effectiveIA = this.invocationAssistance.merge(cimStream.getInvocationAssistanceOverride());
            }
            try {
                if ("CSHARP".equals(language) && effectiveIA.getCsharpAssemblies() != null) {
                    String csharpAssembliesStr = effectiveIA.getCsharpAssemblies();
                    listener.getLogger().println("[Coverity] C# Project detected, assemblies to analyze are: " + csharpAssembliesStr);
                }
                String covAnalyze = null;
                covAnalyze = "JAVA".equals(language) ? "cov-analyze-java" : ("CSHARP".equals(language) ? "cov-analyze-cs" : "cov-analyze");
                if (home != null) {
                    covAnalyze = new FilePath(launcher.getChannel(), home).child("bin").child(covAnalyze).getRemote();
                }
                CoverityLauncherDecorator.SKIP.set(true);
                if (!analyzedLanguages.contains(language)) {
                    boolean csharpAutomaticAssemblies;
                    String csharpAssemblies;
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add(covAnalyze);
                    cmd.add("--dir");
                    cmd.add(temp.tempDir.getRemote());
                    if ("CSHARP".equals(language) && (csharpAssemblies = effectiveIA.getCsharpAssemblies()) != null) {
                        cmd.add(csharpAssemblies);
                    }
                    if (csharpAutomaticAssemblies = this.invocationAssistance.getCsharpAutomaticAssemblies()) {
                        File[] automaticAssemblies;
                        listener.getLogger().println("[Coverity] Searching for C# assemblies...");
                        for (File assembly : automaticAssemblies = this.findAssemblies(build.getWorkspace().getRemote())) {
                            cmd.add(assembly.getAbsolutePath());
                        }
                    }
                    listener.getLogger().println("[Coverity] cmd so far is: " + ((Object)cmd).toString());
                    if (effectiveIA.getAnalyzeArguments() != null) {
                        String[] arr$ = Util.tokenize((String)effectiveIA.getAnalyzeArguments());
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; i$ += 1) {
                            String arg = arr$[i$];
                            cmd.add(arg);
                        }
                    }
                    int result = launcher.launch().cmds(new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]))).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
                    analyzedLanguages.add(language);
                    if (result == 0) continue;
                    listener.getLogger().println("[Coverity] " + covAnalyze + " returned " + result + ", aborting...");
                    build.setResult(Result.FAILURE);
                    boolean len$ = false;
                    return len$;
                }
                listener.getLogger().println("Skipping analysis, because language " + language + " has already been analyzed");
            }
            finally {
                CoverityLauncherDecorator.SKIP.set(false);
            }
        }
        if (this.invocationAssistance != null) {
            boolean csharpMsvsca = this.invocationAssistance.getCsharpMsvsca();
            String csharpMsvscaOutputFiles = this.invocationAssistance.getCsharpMsvscaOutputFiles();
            if (analyzedLanguages.contains("CSHARP") && (csharpMsvsca || csharpMsvscaOutputFiles != null)) {
                String covImportMsvsca = "cov-import-msvsca";
                covImportMsvsca = new FilePath(launcher.getChannel(), home).child("bin").child(covImportMsvsca).getRemote();
                ArrayList<String> importCmd = new ArrayList<String>();
                importCmd.add(covImportMsvsca);
                importCmd.add("--dir");
                importCmd.add(temp.tempDir.getRemote());
                importCmd.add("--append");
                listener.getLogger().println("[Coverity] Searching for Microsoft Code Analysis results...");
                File[] msvscaOutputFiles = new File[]{};
                if (csharpMsvsca) {
                    msvscaOutputFiles = this.findMsvscaOutputFiles(build.getWorkspace().getRemote());
                }
                for (File outputFile : msvscaOutputFiles) {
                    importCmd.add(outputFile.getAbsolutePath());
                }
                if (csharpMsvscaOutputFiles != null && csharpMsvscaOutputFiles.length() > 0) {
                    importCmd.add(csharpMsvscaOutputFiles);
                }
                if (msvscaOutputFiles.length == 0 && (csharpMsvscaOutputFiles == null || csharpMsvscaOutputFiles.length() == 0)) {
                    listener.getLogger().println("[MSVSCA] MSVSCA No results found, skipping");
                } else {
                    listener.getLogger().println("[MSVSCA] MSVSCA Import cmd so far is: " + ((Object)importCmd).toString());
                    int importResult = launcher.launch().cmds(new ArgumentListBuilder(importCmd.toArray(new String[importCmd.size()]))).pwd(build.getWorkspace()).stdout((TaskListener)listener).join();
                    if (importResult != 0) {
                        listener.getLogger().println("[Coverity] " + covImportMsvsca + " returned " + importResult + ", aborting...");
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                }
            }
        }
        for (CIMStream cimStream : this.getCimStreams()) {
            cim = this.getDescriptor().getInstance(cimStream.getInstance());
            language = null;
            try {
                language = this.getLanguage(cimStream);
            }
            catch (CovRemoteServiceException_Exception e) {
                e.printStackTrace(listener.error("Error while retrieving stream information for " + cimStream.getStream()));
                return false;
            }
            if (this.invocationAssistance == null) continue;
            effectiveIA = this.invocationAssistance;
            if (cimStream.getInvocationAssistanceOverride() != null) {
                effectiveIA = this.invocationAssistance.merge(cimStream.getInvocationAssistanceOverride());
            }
            try {
                if ("CSHARP".equals(language) && effectiveIA.getCsharpAssemblies() != null) {
                    String csharpAssembliesStr = effectiveIA.getCsharpAssemblies();
                    listener.getLogger().println("[Coverity] C# Project detected, assemblies to analyze are: " + csharpAssembliesStr);
                }
                String covCommitDefects = "cov-commit-defects";
                if (home != null) {
                    covCommitDefects = new FilePath(launcher.getChannel(), home).child("bin").child(covCommitDefects).getRemote();
                }
                CoverityLauncherDecorator.SKIP.set(true);
                boolean useDataPort = cim.getDataPort() != 0;
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(covCommitDefects);
                cmd.add("--dir");
                cmd.add(temp.tempDir.getRemote());
                cmd.add("--host");
                cmd.add(cim.getHost());
                cmd.add(useDataPort ? "--dataport" : "--port");
                cmd.add(useDataPort ? Integer.toString(cim.getDataPort()) : Integer.toString(cim.getPort()));
                cmd.add("--stream");
                cmd.add(cimStream.getStream());
                cmd.add("--user");
                cmd.add(cim.getUser());
                if (effectiveIA.getCommitArguments() != null) {
                    for (String arg : Util.tokenize((String)effectiveIA.getCommitArguments())) {
                        cmd.add(arg);
                    }
                }
                ArgumentListBuilder args = new ArgumentListBuilder(cmd.toArray(new String[cmd.size()]));
                int result = launcher.launch().cmds(args).envs(Collections.singletonMap("COVERITY_PASSPHRASE", cim.getPassword())).stdout((TaskListener)listener).stderr((OutputStream)listener.getLogger()).join();
                if (result == 0) continue;
                listener.getLogger().println("[Coverity] cov-commit-defects returned " + result + ", aborting...");
                build.setResult(Result.FAILURE);
                i$ = 0;
                return i$ != 0;
            }
            finally {
                CoverityLauncherDecorator.SKIP.set(false);
            }
        }
        if (temp != null) {
            if (!this.keepIntDir || temp.def) {
                listener.getLogger().println("[Coverity] deleting intermediate directory");
                temp.tempDir.deleteRecursive();
            } else {
                listener.getLogger().println("[Coverity] preserving intermediate directory: " + temp.tempDir);
            }
        }
        Pattern snapshotPattern = Pattern.compile(".*New snapshot ID (\\d*) added.");
        BufferedReader reader = new BufferedReader(build.getLogReader());
        String line = null;
        ArrayList<Long> snapshotIds = new ArrayList<Long>();
        try {
            while ((line = reader.readLine()) != null) {
                Matcher m = snapshotPattern.matcher(line);
                if (!m.matches()) continue;
                snapshotIds.add(Long.parseLong(m.group(1)));
            }
        }
        finally {
            reader.close();
        }
        if (snapshotIds.size() != this.getCimStreams().size()) {
            listener.getLogger().println("[Coverity] Wrong number of snapshot IDs found in build log");
            build.setResult(Result.FAILURE);
            return false;
        }
        listener.getLogger().println("[Coverity] Found snapshot IDs " + snapshotIds);
        if (!this.skipFetchingDefects) {
            for (int i = 0; i < this.cimStreams.size(); ++i) {
                CIMStream cimStream = this.cimStreams.get(i);
                long snapshotId = (Long)snapshotIds.get(i);
                try {
                    String rootUrl;
                    CIMInstance cim2 = this.getDescriptor().getInstance(cimStream.getInstance());
                    listener.getLogger().println("[Coverity] Fetching defects for stream " + cimStream.getStream());
                    List<MergedDefectDataObj> defects = this.getDefectsForSnapshot(cimStream, snapshotId);
                    listener.getLogger().println("[Coverity] Found " + defects.size() + " defects");
                    HashSet<String> checkers = new HashSet<String>();
                    for (MergedDefectDataObj defect : defects) {
                        checkers.add(defect.getCheckerName());
                    }
                    this.getDescriptor().updateCheckers(this.getLanguage(cimStream), checkers);
                    ArrayList<Long> matchingDefects = new ArrayList<Long>();
                    for (MergedDefectDataObj defect : defects) {
                        if (cimStream.getDefectFilters() == null) {
                            matchingDefects.add(defect.getCid());
                            continue;
                        }
                        boolean match = cimStream.getDefectFilters().matches(defect);
                        if (!match) continue;
                        matchingDefects.add(defect.getCid());
                    }
                    if (!matchingDefects.isEmpty()) {
                        listener.getLogger().println("[Coverity] Found " + matchingDefects.size() + " defects matching all filters: " + matchingDefects);
                        if (this.failBuild && build.getResult().isBetterThan(Result.FAILURE)) {
                            build.setResult(Result.FAILURE);
                        }
                    } else {
                        listener.getLogger().println("[Coverity] No defects matched all filters.");
                    }
                    CoverityBuildAction action = new CoverityBuildAction(build, cimStream.getProject(), cimStream.getStream(), cimStream.getInstance(), matchingDefects);
                    build.addAction((Action)action);
                    if (!matchingDefects.isEmpty() && this.mailSender != null) {
                        this.mailSender.execute(action, listener);
                    }
                    if ((rootUrl = Hudson.getInstance().getRootUrl()) == null) continue;
                    listener.getLogger().println("Coverity details: " + Hudson.getInstance().getRootUrl() + build.getUrl() + action.getUrlName());
                    continue;
                }
                catch (CovRemoteServiceException_Exception e) {
                    e.printStackTrace(listener.error("[Coverity] An error occurred while fetching defects"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
        }
        return true;
    }

    public List<MergedDefectDataObj> getDefectsForSnapshot(CIMStream cimStream, long snapshotId) throws IOException, CovRemoteServiceException_Exception {
        CIMInstance cim = this.getDescriptor().getInstance(cimStream.getInstance());
        DefectService ds = cim.getDefectService();
        PageSpecDataObj pageSpec = new PageSpecDataObj();
        pageSpec.setPageSize(1000);
        pageSpec.setSortAscending(true);
        StreamIdDataObj streamId = new StreamIdDataObj();
        streamId.setName(cimStream.getStream());
        MergedDefectFilterSpecDataObj filter = new MergedDefectFilterSpecDataObj();
        StreamSnapshotFilterSpecDataObj sfilter = new StreamSnapshotFilterSpecDataObj();
        SnapshotIdDataObj snapid = new SnapshotIdDataObj();
        snapid.setId(snapshotId);
        sfilter.setStreamId(streamId);
        sfilter.getSnapshotIdIncludeList().add(snapid);
        filter.getStreamSnapshotFilterSpecIncludeList().add(sfilter);
        return ds.getMergedDefectsForStreams(Arrays.asList(streamId), filter, pageSpec).getMergedDefects();
    }

    public String getLanguage(CIMStream cimStream) throws IOException, CovRemoteServiceException_Exception {
        return this.getDescriptor().getInstance(cimStream.getInstance()).getStream(cimStream.getStream()).getLanguage();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<CIMInstance> instances = new ArrayList<CIMInstance>();
        private String home;
        private String javaCheckers;
        private String cxxCheckers;
        private String csharpCheckers;

        public DescriptorImpl() {
            super(CoverityPublisher.class);
            this.load();
            this.setJavaCheckers(this.javaCheckers);
            this.setCxxCheckers(this.cxxCheckers);
            this.setCsharpCheckers(this.csharpCheckers);
        }

        public static List<String> toStrings(ListBoxModel list) {
            ArrayList<String> result = new ArrayList<String>();
            for (ListBoxModel.Option option : list) {
                result.add(option.name);
            }
            return result;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.home = Util.fixEmpty((String)this.home);
            this.save();
            return true;
        }

        public String getHome() {
            return this.home;
        }

        public void setHome(String home) {
            this.home = home;
        }

        public String getJavaCheckers() {
            return this.javaCheckers;
        }

        public void setJavaCheckers(String javaCheckers) {
            this.javaCheckers = Util.fixEmpty((String)javaCheckers);
            try {
                this.javaCheckers = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("java-checkers.txt"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getCxxCheckers() {
            return this.cxxCheckers;
        }

        public void setCxxCheckers(String cxxCheckers) {
            this.cxxCheckers = Util.fixEmpty((String)cxxCheckers);
            try {
                this.cxxCheckers = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("cxx-checkers.txt"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getCsharpCheckers() {
            return this.csharpCheckers;
        }

        public void setCsharpCheckers(String csharpCheckers) {
            this.csharpCheckers = Util.fixEmpty((String)csharpCheckers);
            try {
                this.csharpCheckers = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("csharp-checkers.txt"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getHome(Node node, EnvVars environment) {
            CoverityInstallation install = (CoverityInstallation)node.getNodeProperties().get(CoverityInstallation.class);
            if (install != null) {
                return install.forEnvironment(environment).getHome();
            }
            if (this.home != null) {
                return new CoverityInstallation(this.home).forEnvironment(environment).getHome();
            }
            return null;
        }

        public List<CIMInstance> getInstances() {
            return this.instances;
        }

        public void setInstances(List<CIMInstance> instances) {
            this.instances = instances;
        }

        public CIMInstance getInstance(String name) {
            for (CIMInstance instance : this.instances) {
                if (!instance.getName().equals(name)) continue;
                return instance;
            }
            return null;
        }

        public String getDisplayName() {
            return "Coverity";
        }

        public FormValidation doCheckInstance(@QueryParameter String host, @QueryParameter int port, @QueryParameter boolean useSSL, @QueryParameter String user, @QueryParameter String password, @QueryParameter int dataPort) throws IOException {
            return new CIMInstance("", host, port, user, password, useSSL, dataPort).doCheck();
        }

        public FormValidation doCheckCutOffDate(@QueryParameter String value) throws Descriptor.FormException {
            try {
                if (!StringUtils.isEmpty((String)value)) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                return FormValidation.ok();
            }
            catch (ParseException e) {
                return FormValidation.error((String)"yyyy-MM-dd expected");
            }
        }

        public ListBoxModel split(String string) {
            ListBoxModel result = new ListBoxModel();
            for (String s : string.split("[\r\n]")) {
                if ((s = Util.fixEmptyAndTrim((String)s)) == null) continue;
                result.add(s);
            }
            return result;
        }

        public Set<String> split2(String string) {
            TreeSet<String> result = new TreeSet<String>();
            for (String s : string.split("[\r\n]")) {
                if ((s = Util.fixEmptyAndTrim((String)s)) == null) continue;
                result.add(s);
            }
            return result;
        }

        public FormValidation doCheckDate(@QueryParameter String date) {
            try {
                if (!StringUtils.isEmpty((String)date.trim())) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(date);
                }
                return FormValidation.ok();
            }
            catch (ParseException e) {
                return FormValidation.error((String)"Date in yyyy-mm-dd format expected");
            }
        }

        public String getCheckers(String language) {
            if ("CXX".equals(language)) {
                return this.cxxCheckers;
            }
            if ("JAVA".equals(language)) {
                return this.javaCheckers;
            }
            if ("CSHARP".equals(language)) {
                return this.csharpCheckers;
            }
            throw new IllegalArgumentException("Unknown language: " + language);
        }

        public void setCheckers(String language, Set<String> checkers) {
            if ("CXX".equals(language)) {
                this.cxxCheckers = this.join(checkers);
            } else if ("JAVA".equals(language)) {
                this.javaCheckers = this.join(checkers);
            } else if ("CSHARP".equals(language)) {
                this.csharpCheckers = this.join(checkers);
            } else {
                throw new IllegalArgumentException(language);
            }
        }

        public void updateCheckers(String language, Set<String> checkers) {
            String oldCheckers = this.getCheckers(language);
            TreeSet<String> newCheckers = new TreeSet<String>();
            TreeSet<String> c = new TreeSet<String>();
            for (ListBoxModel.Option option : this.split(oldCheckers)) {
                c.add(option.name);
            }
            for (String string : checkers) {
                if (!c.add(string)) continue;
                newCheckers.add(string);
            }
            this.setCheckers(language, c);
            this.save();
        }

        private String join(Collection<String> c) {
            StringBuffer result = new StringBuffer();
            for (String s : c) {
                result.append(s).append("\n");
            }
            return result.toString();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            logger.info(formData.toString());
            String cutOffDate = Util.fixEmpty((String)req.getParameter("cutOffDate"));
            try {
                if (cutOffDate != null) {
                    new SimpleDateFormat("yyyy-MM-dd").parse(cutOffDate);
                }
            }
            catch (ParseException e) {
                throw new Descriptor.FormException("Could not parse date '" + cutOffDate + "', yyyy-MM-dd expected", "cutOffDate");
            }
            CoverityPublisher publisher = (CoverityPublisher)super.newInstance(req, formData);
            for (CIMStream current : publisher.getCimStreams()) {
                CIMStream.DescriptorImpl currentDescriptor = (CIMStream.DescriptorImpl)current.getDescriptor();
                String cimInstance = current.getInstance();
                try {
                    if (!current.isValid()) continue;
                    String language = publisher.getLanguage(current);
                    Set<String> allCheckers = this.split2(this.getCheckers(language));
                    DefectFilters defectFilters = current.getDefectFilters();
                    if (defectFilters == null) continue;
                    defectFilters.invertCheckers(allCheckers, DescriptorImpl.toStrings(currentDescriptor.doFillClassificationDefectFilterItems(cimInstance)), DescriptorImpl.toStrings(currentDescriptor.doFillActionDefectFilterItems(cimInstance)), DescriptorImpl.toStrings(currentDescriptor.doFillSeveritiesDefectFilterItems(cimInstance)), DescriptorImpl.toStrings(currentDescriptor.doFillComponentDefectFilterItems(cimInstance, current.getStream())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return publisher;
        }

        public void doDefectFiltersConfig(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            logger.info(req.getSubmittedForm().toString());
            JSONObject json = null;
            JSONObject jsonA = req.getSubmittedForm().getJSONObject(this.getJsonSafeClassName());
            if (jsonA == null || jsonA.toString().equals("null")) {
                JSON jsonB = (JSON)req.getSubmittedForm().get("publisher");
                String targetClass = this.getId();
                if (jsonB.isArray()) {
                    JSONArray arr = (JSONArray)jsonB;
                    for (Object i : arr) {
                        JSONObject ji = (JSONObject)i;
                        if (!targetClass.equals(ji.get("stapler-class"))) continue;
                        json = ji;
                        break;
                    }
                } else {
                    json = (JSONObject)jsonB;
                }
            } else {
                json = jsonA;
            }
            CIMStream current = null;
            CIMStream.DescriptorImpl currentDescriptor = null;
            if (json != null && !json.isNullObject()) {
                CoverityPublisher publisher = (CoverityPublisher)((Object)req.bindJSON(CoverityPublisher.class, json));
                String id = ((String[])req.getParameterMap().get("id"))[0];
                for (CIMStream cs : publisher.getCimStreams()) {
                    if (!id.equals(cs.getId())) continue;
                    current = cs;
                }
                currentDescriptor = (CIMStream.DescriptorImpl)current.getDescriptor();
                if (!(StringUtils.isEmpty((String)current.getInstance()) || StringUtils.isEmpty((String)current.getStream()) || StringUtils.isEmpty((String)current.getProject()))) {
                    try {
                        String language = publisher.getLanguage(current);
                        Set<String> allCheckers = this.split2(this.getCheckers(language));
                        DefectFilters defectFilters = current.getDefectFilters();
                        if (defectFilters != null) {
                            current.getDefectFilters().invertCheckers(allCheckers, DescriptorImpl.toStrings(currentDescriptor.doFillClassificationDefectFilterItems(current.getInstance())), DescriptorImpl.toStrings(currentDescriptor.doFillActionDefectFilterItems(current.getInstance())), DescriptorImpl.toStrings(currentDescriptor.doFillSeveritiesDefectFilterItems(current.getInstance())), DescriptorImpl.toStrings(currentDescriptor.doFillComponentDefectFilterItems(current.getInstance(), current.getStream())));
                        }
                    }
                    catch (CovRemoteServiceException_Exception e) {
                        throw new IOException(e);
                    }
                }
                req.setAttribute("descriptor", (Object)currentDescriptor);
                req.setAttribute("instance", (Object)current);
                req.setAttribute("id", (Object)id);
            }
            rsp.forward(currentDescriptor, "defectFilters", req);
        }
    }
}

