/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.coverity;

import hudson.Util;
import org.kohsuke.stapler.DataBoundConstructor;

public class InvocationAssistance {
    private final String buildArguments;
    private final String analyzeArguments;
    private final String commitArguments;
    private final String csharpAssemblies;
    private final String javaWarFile;
    private final String csharpMsvscaOutputFiles;
    private final boolean csharpAutomaticAssemblies;
    private final boolean csharpMsvsca;
    private final String saOverride;
    private final String covBuildBlacklist;
    private final String intermediateDir;

    @DataBoundConstructor
    public InvocationAssistance(String buildArguments, String analyzeArguments, String commitArguments, String intermediateDir, String csharpAssemblies, String javaWarFile, String csharpMsvscaOutputFiles, boolean csharpAutomaticAssemblies, boolean csharpMsvsca, String saOverride, String covBuildBlacklist) {
        this.intermediateDir = Util.fixEmpty((String)intermediateDir);
        this.buildArguments = Util.fixEmpty((String)buildArguments);
        this.analyzeArguments = Util.fixEmpty((String)analyzeArguments);
        this.commitArguments = Util.fixEmpty((String)commitArguments);
        this.csharpAssemblies = Util.fixEmpty((String)csharpAssemblies);
        this.javaWarFile = Util.fixEmpty((String)javaWarFile);
        this.csharpMsvscaOutputFiles = Util.fixEmpty((String)csharpMsvscaOutputFiles);
        this.csharpMsvsca = csharpMsvsca;
        this.csharpAutomaticAssemblies = csharpAutomaticAssemblies;
        this.saOverride = Util.fixEmpty((String)saOverride);
        this.covBuildBlacklist = Util.fixEmpty((String)covBuildBlacklist);
    }

    public String getBuildArguments() {
        return this.buildArguments;
    }

    public String getAnalyzeArguments() {
        return this.analyzeArguments;
    }

    public String getCommitArguments() {
        return this.commitArguments;
    }

    public String getIntermediateDir() {
        return this.intermediateDir;
    }

    public String getCsharpAssemblies() {
        return this.csharpAssemblies;
    }

    public String getJavaWarFile() {
        return this.javaWarFile;
    }

    public String getCsharpMsvscaOutputFiles() {
        return this.csharpMsvscaOutputFiles;
    }

    public boolean getCsharpMsvsca() {
        return this.csharpMsvsca;
    }

    public boolean getCsharpAutomaticAssemblies() {
        return this.csharpAutomaticAssemblies;
    }

    public String getSaOverride() {
        return this.saOverride;
    }

    public String getCovBuildBlacklist() {
        return this.covBuildBlacklist;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationAssistance that = (InvocationAssistance)o;
        if (this.csharpAutomaticAssemblies != that.csharpAutomaticAssemblies) {
            return false;
        }
        if (this.csharpMsvsca != that.csharpMsvsca) {
            return false;
        }
        if (this.analyzeArguments != null ? !this.analyzeArguments.equals(that.analyzeArguments) : that.analyzeArguments != null) {
            return false;
        }
        if (this.buildArguments != null ? !this.buildArguments.equals(that.buildArguments) : that.buildArguments != null) {
            return false;
        }
        if (this.commitArguments != null ? !this.commitArguments.equals(that.commitArguments) : that.commitArguments != null) {
            return false;
        }
        if (this.covBuildBlacklist != null ? !this.covBuildBlacklist.equals(that.covBuildBlacklist) : that.covBuildBlacklist != null) {
            return false;
        }
        if (this.csharpAssemblies != null ? !this.csharpAssemblies.equals(that.csharpAssemblies) : that.csharpAssemblies != null) {
            return false;
        }
        if (this.csharpMsvscaOutputFiles != null ? !this.csharpMsvscaOutputFiles.equals(that.csharpMsvscaOutputFiles) : that.csharpMsvscaOutputFiles != null) {
            return false;
        }
        if (this.intermediateDir != null ? !this.intermediateDir.equals(that.intermediateDir) : that.intermediateDir != null) {
            return false;
        }
        if (this.javaWarFile != null ? !this.javaWarFile.equals(that.javaWarFile) : that.javaWarFile != null) {
            return false;
        }
        return !(this.saOverride != null ? !this.saOverride.equals(that.saOverride) : that.saOverride != null);
    }

    public int hashCode() {
        int result = this.buildArguments != null ? this.buildArguments.hashCode() : 0;
        result = 31 * result + (this.analyzeArguments != null ? this.analyzeArguments.hashCode() : 0);
        result = 31 * result + (this.commitArguments != null ? this.commitArguments.hashCode() : 0);
        result = 31 * result + (this.csharpAssemblies != null ? this.csharpAssemblies.hashCode() : 0);
        result = 31 * result + (this.javaWarFile != null ? this.javaWarFile.hashCode() : 0);
        result = 31 * result + (this.csharpMsvscaOutputFiles != null ? this.csharpMsvscaOutputFiles.hashCode() : 0);
        result = 31 * result + (this.csharpAutomaticAssemblies ? 1 : 0);
        result = 31 * result + (this.csharpMsvsca ? 1 : 0);
        result = 31 * result + (this.saOverride != null ? this.saOverride.hashCode() : 0);
        result = 31 * result + (this.covBuildBlacklist != null ? this.covBuildBlacklist.hashCode() : 0);
        result = 31 * result + (this.intermediateDir != null ? this.intermediateDir.hashCode() : 0);
        return result;
    }

    public InvocationAssistance merge(InvocationAssistance override) {
        String analyzeArguments = override.getAnalyzeArguments() != null ? override.getAnalyzeArguments() : this.getAnalyzeArguments();
        String buildArguments = override.getBuildArguments() != null ? override.getBuildArguments() : this.getBuildArguments();
        String commitArguments = override.getCommitArguments() != null ? override.getCommitArguments() : this.getCommitArguments();
        String covBuildBlacklist = override.getCovBuildBlacklist() != null ? override.getCovBuildBlacklist() : this.getCovBuildBlacklist();
        String csharpAssemblies = override.getCsharpAssemblies() != null ? override.getCsharpAssemblies() : this.getCsharpAssemblies();
        String intermediateDir = override.getIntermediateDir() != null ? override.getIntermediateDir() : this.getIntermediateDir();
        String javaWarFile = override.getJavaWarFile() != null ? override.getJavaWarFile() : this.getJavaWarFile();
        String csharpMsvscaOutputFiles = override.getCsharpMsvscaOutputFiles() != null ? override.getCsharpMsvscaOutputFiles() : this.getCsharpMsvscaOutputFiles();
        boolean csharpAutomaticAssemblies = override.getCsharpAutomaticAssemblies();
        boolean csharpMsvsca = override.getCsharpMsvsca();
        String saOverride = override.getSaOverride() != null ? override.getSaOverride() : this.getSaOverride();
        return new InvocationAssistance(buildArguments, analyzeArguments, commitArguments, intermediateDir, csharpAssemblies, javaWarFile, csharpMsvscaOutputFiles, csharpAutomaticAssemblies, csharpMsvsca, saOverride, covBuildBlacklist);
    }
}

