/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.Plugin;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.plugins.createjobadvanced.DynamicPermissionConfig;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class CreateJobAdvancedPlugin
extends Plugin {
    static Logger log = Logger.getLogger(CreateJobAdvancedPlugin.class.getName());
    private boolean autoOwnerRights;
    private boolean autoPublicBrowse;
    private boolean replaceSpace;
    private boolean activeLogRotator;
    private int daysToKeep = -1;
    private int numToKeep = -1;
    private int artifactDaysToKeep = -1;
    private int artifactNumToKeep = -1;
    private boolean activeDynamicPermissions;
    private String extractPattern;
    private List<DynamicPermissionConfig> dynamicPermissionConfigs = new ArrayList();

    public List<DynamicPermissionConfig> getDynamicPermissionConfigs() {
        return this.dynamicPermissionConfigs;
    }

    public void start() throws Exception {
        super.start();
        log.info("Create job advanced plugin started ...");
        this.load();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.autoOwnerRights = req.getParameter("cja.security") != null && req.getParameter("cja.security") != "false";
        this.autoPublicBrowse = req.getParameter("cja.public") != null && req.getParameter("cja.public") != "false";
        this.replaceSpace = req.getParameter("cja.jobspacesinname") != null && req.getParameter("cja.jobspacesinname") != "false";
        this.activeLogRotator = req.getParameter("cja.activeLogRotator") != null && req.getParameter("cja.activeLogRotator") != "false";
        if (this.activeLogRotator) {
            try {
                this.daysToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.daysToKeep")));
            }
            catch (Exception e) {
                this.daysToKeep = -1;
            }
            try {
                this.numToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.numToKeep")));
            }
            catch (Exception e) {
                this.numToKeep = -1;
            }
            try {
                this.artifactDaysToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.artifactDaysToKeep")));
            }
            catch (Exception e) {
                this.artifactDaysToKeep = -1;
            }
            try {
                this.artifactNumToKeep = Integer.valueOf(Util.fixNull((String)req.getParameter("cja.artifactNumToKeep")));
            }
            catch (Exception e) {
                this.artifactNumToKeep = -1;
            }
        }
        this.activeDynamicPermissions = req.getParameter("cja.activeDynamicPermissions") != null && req.getParameter("cja.activeDynamicPermissions") != "false";
        if (this.activeDynamicPermissions) {
            if (req.getParameter("cja.extractPattern") != null) {
                this.extractPattern = req.getParameter("cja.extractPattern");
            }
            for (Object o : JSONArray.fromObject((Object)formData.get("activeDynamicPermissions"))) {
                JSONObject jo = (JSONObject)o;
                this.dynamicPermissionConfigs.clear();
                Object cfgs = jo.get("cfgs");
                if (cfgs instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)cfgs;
                    for (Object object : jsonArray) {
                        this.addDynamicPermission(req, (JSONObject)object);
                    }
                    continue;
                }
                this.addDynamicPermission(req, (JSONObject)cfgs);
            }
        }
        this.save();
    }

    private void addDynamicPermission(StaplerRequest req, JSONObject jsonObject) {
        DynamicPermissionConfig dynPerm = (DynamicPermissionConfig)req.bindJSON(DynamicPermissionConfig.class, jsonObject);
        List allPossiblePermissions = CreateJobAdvancedPlugin.getAllPossiblePermissions();
        for (Permission permission : allPossiblePermissions) {
            String enabled = jsonObject.getString(permission.getId());
            if (!Boolean.valueOf(enabled).booleanValue()) continue;
            dynPerm.addPermissionId(permission.getId());
            log.log(Level.FINE, "enable {0}", new String[]{permission.getId()});
        }
        this.dynamicPermissionConfigs.add(dynPerm);
    }

    public static List<Permission> getAllPossiblePermissions() {
        ArrayList<Permission> enabledPerms = new ArrayList<Permission>();
        CreateJobAdvancedPlugin.addEnabledPermissionsForGroup(enabledPerms, Item.class);
        CreateJobAdvancedPlugin.addEnabledPermissionsForGroup(enabledPerms, Run.class);
        return enabledPerms;
    }

    private static void addEnabledPermissionsForGroup(List<Permission> enabledPerms, Class owner) {
        PermissionGroup permissionGroup = PermissionGroup.get((Class)owner);
        List permissions = permissionGroup.getPermissions();
        for (Permission permission : permissions) {
            if (!permission.enabled) continue;
            enabledPerms.add(permission);
        }
    }

    public boolean isAutoOwnerRights() {
        return this.autoOwnerRights;
    }

    public boolean isAutoPublicBrowse() {
        return this.autoPublicBrowse;
    }

    public boolean isReplaceSpace() {
        return this.replaceSpace;
    }

    public boolean isActiveLogRotator() {
        return this.activeLogRotator;
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public int getArtifactDaysToKeep() {
        return this.artifactDaysToKeep;
    }

    public int getArtifactNumToKeep() {
        return this.artifactNumToKeep;
    }

    public String getExtractPattern() {
        return this.extractPattern;
    }

    public boolean isActiveDynamicPermissions() {
        return this.activeDynamicPermissions;
    }
}

