/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.listeners.ItemListener;
import hudson.plugins.createjobadvanced.CreateJobAdvancedPlugin;
import hudson.plugins.createjobadvanced.DynamicPermissionConfig;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.Permission;
import hudson.security.SecurityMode;
import hudson.tasks.LogRotator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class ItemListenerImpl
extends ItemListener {
    static Logger log = Logger.getLogger(CreateJobAdvancedPlugin.class.getName());

    @DataBoundConstructor
    public ItemListenerImpl() {
    }

    public void onRenamed(Item item, String oldName, String newName) {
        log.info("renamed " + oldName + " to " + newName);
        if (!(item instanceof Job)) {
            return;
        }
        Job job = (Job)item;
        CreateJobAdvancedPlugin cja = (CreateJobAdvancedPlugin)Hudson.getInstance().getPlugin(CreateJobAdvancedPlugin.class);
        if (cja.isReplaceSpace()) {
            this.renameJob(job);
        }
    }

    public void onCreated(Item item) {
        if (!(item instanceof Job)) {
            return;
        }
        Job job = (Job)item;
        CreateJobAdvancedPlugin cja = (CreateJobAdvancedPlugin)Hudson.getInstance().getPlugin(CreateJobAdvancedPlugin.class);
        if (cja.isReplaceSpace()) {
            this.renameJob(job);
        }
        if (!Hudson.getInstance().getSecurity().equals((Object)SecurityMode.UNSECURED)) {
            if (cja.isAutoOwnerRights()) {
                String sid = Hudson.getAuthentication().getName();
                this.securityGrantPermissions(job, sid, new Permission[]{Item.CONFIGURE, Item.BUILD, Item.READ, Item.DELETE, Item.WORKSPACE});
            }
            if (cja.isAutoPublicBrowse()) {
                this.securityGrantPermissions(job, "anonymous", new Permission[]{Item.READ, Item.WORKSPACE});
            }
            if (cja.isActiveDynamicPermissions()) {
                this.securityGrantDynamicPermissions(job, cja);
            }
        }
        if (cja.isActiveLogRotator()) {
            this.activateLogRotator(job, cja);
        }
    }

    private void securityGrantDynamicPermissions(Job<?, ?> job, CreateJobAdvancedPlugin cja) {
        Pattern pattern;
        Matcher matcher;
        boolean matchFound;
        String patternStr = cja.getExtractPattern();
        ArrayList<String> groupsList = new ArrayList<String>();
        if (patternStr != null && (matchFound = (matcher = (pattern = Pattern.compile(patternStr)).matcher(job.getName())).find())) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                String groupStr = matcher.group(i);
                log.log(Level.FINE, "groupStr: " + groupStr);
                groupsList.add(groupStr);
            }
        }
        for (DynamicPermissionConfig dpc : cja.getDynamicPermissionConfigs()) {
            MessageFormat format = new MessageFormat(dpc.getGroupFormat());
            String newName = format.format(groupsList.toArray(new String[0]));
            log.log(Level.FINE, "add perms for group: " + newName);
            Set permissions = dpc.getCheckedPermissionIds();
            ArrayList<Permission> permissionList = new ArrayList<Permission>();
            for (String id : permissions) {
                Permission permForId = Permission.fromId((String)id);
                permissionList.add(permForId);
            }
            this.securityGrantPermissions(job, newName, permissionList.toArray(new Permission[permissionList.size()]));
        }
    }

    private void activateLogRotator(Job<?, ?> job, CreateJobAdvancedPlugin cja) {
        if (job.getLogRotator() != null) {
            return;
        }
        LogRotator logrotator = new LogRotator(cja.getDaysToKeep(), cja.getNumToKeep(), cja.getArtifactDaysToKeep(), cja.getArtifactNumToKeep());
        job.setLogRotator(logrotator);
    }

    private void renameJob(Job<?, ?> job) {
        if (job.getName().indexOf(" ") != -1) {
            try {
                job.renameTo(job.getName().replaceAll(" ", "-"));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "error during rename", e);
            }
        }
    }

    private void securityGrantPermissions(Job<?, ?> job, String sid, Permission[] hudsonPermissions) {
        Map permissions = this.initPermissions(job);
        for (Permission perm : hudsonPermissions) {
            this.configurePermission(permissions, perm, sid);
        }
        try {
            AuthorizationMatrixProperty authProperty = new AuthorizationMatrixProperty(permissions);
            job.addProperty((JobProperty)authProperty);
            log.info("Granding rights to [" + sid + "] for newly-created job " + job.getDisplayName());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "problem to add granted permissions", e);
        }
    }

    private Map<Permission, Set<String>> initPermissions(Job<?, ?> job) {
        HashMap<Permission, Set<String>> permissions = null;
        AuthorizationMatrixProperty auth = (AuthorizationMatrixProperty)job.getProperty(AuthorizationMatrixProperty.class);
        if (auth != null) {
            permissions = new HashMap(auth.getGrantedPermissions());
            try {
                job.removeProperty(AuthorizationMatrixProperty.class);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "problem to remove granted permissions (template or copy job)", e);
            }
        } else {
            permissions = new HashMap<Permission, Set<String>>();
        }
        return permissions;
    }

    private void configurePermission(Map<Permission, Set<String>> permissions, Permission permission, String sid) {
        Set<String> sidPermission = permissions.get(permission);
        if (sidPermission == null) {
            HashSet<String> sidSet = new HashSet<String>();
            sidSet.add(sid);
            permissions.put(permission, sidSet);
        } else if (!sidPermission.contains(sid)) {
            sidPermission.add(sid);
        }
    }
}

