/*
 * Decompiled with CFR 0.152.
 */
package de.theit.jenkins.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import de.theit.jenkins.crowd.CrowdAuthenticationToken;
import de.theit.jenkins.crowd.CrowdConfigurationService;
import de.theit.jenkins.crowd.ErrorMessages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.security.AccountExpiredException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.CredentialsExpiredException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.InsufficientAuthenticationException;

public class CrowdAuthenticationManager
implements AuthenticationManager {
    private static final Logger LOG = Logger.getLogger(CrowdAuthenticationManager.class.getName());
    private CrowdConfigurationService configuration;

    public CrowdAuthenticationManager(CrowdConfigurationService pConfiguration) {
        this.configuration = pConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getPrincipal().toString();
        if (null == authentication.getCredentials() && authentication instanceof CrowdAuthenticationToken && null != ((CrowdAuthenticationToken)authentication).getSSOToken()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("User '" + username + "' already authenticated");
            }
            return authentication;
        }
        String password = authentication.getCredentials().toString();
        if (!this.configuration.isGroupMember(username)) {
            throw new InsufficientAuthenticationException(ErrorMessages.userNotValid((String)username, (Collection)this.configuration.allowedGroupNames));
        }
        String displayName = null;
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Authenticating user: " + username);
            }
            User user = this.configuration.crowdClient.authenticateUser(username, password);
            displayName = user.getDisplayName();
        }
        catch (UserNotFoundException ex) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(ErrorMessages.userNotFound((String)username));
            }
            throw new BadCredentialsException(ErrorMessages.userNotFound((String)username), (Throwable)ex);
        }
        catch (ExpiredCredentialException ex) {
            LOG.warning(ErrorMessages.expiredCredentials((String)username));
            throw new CredentialsExpiredException(ErrorMessages.expiredCredentials((String)username), (Throwable)ex);
        }
        catch (InactiveAccountException ex) {
            LOG.warning(ErrorMessages.accountExpired((String)username));
            throw new AccountExpiredException(ErrorMessages.accountExpired((String)username), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new AuthenticationServiceException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new AuthenticationServiceException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new AuthenticationServiceException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        authorities.addAll(this.configuration.getAuthoritiesForUser(username));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("User successfully authenticated; creating authentication token");
        }
        return new CrowdAuthenticationToken(username, password, authorities, null, displayName);
    }
}

