/*
 * Decompiled with CFR 0.152.
 */
package de.theit.jenkins.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticatorImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import de.theit.jenkins.crowd.CrowdAuthenticationManager;
import de.theit.jenkins.crowd.CrowdConfigurationService;
import de.theit.jenkins.crowd.CrowdRememberMeServices;
import de.theit.jenkins.crowd.CrowdServletFilter;
import de.theit.jenkins.crowd.CrowdUser;
import de.theit.jenkins.crowd.CrowdUserDetailsService;
import de.theit.jenkins.crowd.ErrorMessages;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.AccountExpiredException;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.InsufficientAuthenticationException;
import org.springframework.security.ui.rememberme.RememberMeServices;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class CrowdSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final Logger LOG = Logger.getLogger(CrowdSecurityRealm.class.getName());
    public final String url;
    public final String applicationName;
    public final String password;
    public final String group;
    public final boolean nestedGroups;
    private final int sessionValidationInterval;
    private transient CrowdConfigurationService configuration;

    @DataBoundConstructor
    public CrowdSecurityRealm(String url, String applicationName, String password, String group, boolean nestedGroups, int sessionValidationInterval) {
        this.url = url.trim();
        this.applicationName = applicationName.trim();
        this.password = password.trim();
        this.group = group.trim();
        this.nestedGroups = nestedGroups;
        this.sessionValidationInterval = sessionValidationInterval;
    }

    private void initializeConfiguration() {
        Properties props = new Properties();
        try {
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("/crowd.properties"));
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.cannotLoadCrowdProperties(), ex);
        }
        if (this.applicationName != null || this.password != null || this.url != null) {
            String crowdUrl = this.url;
            if (!crowdUrl.endsWith("/")) {
                crowdUrl = crowdUrl + "/";
            }
            props.setProperty("application.name", this.applicationName);
            props.setProperty("application.password", this.password);
            props.setProperty("crowd.base.url", crowdUrl);
            props.setProperty("application.login.url", crowdUrl + "console/");
            props.setProperty("crowd.server.url", this.url + "services/");
            props.setProperty("session.validationinterval", String.valueOf(this.sessionValidationInterval));
        } else {
            LOG.warning("Client properties are incomplete");
        }
        this.configuration = new CrowdConfigurationService(this.group, this.nestedGroups);
        this.configuration.clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)props);
        this.configuration.crowdClient = new RestCrowdClientFactory().newInstance(this.configuration.clientProperties);
        this.configuration.tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
        this.configuration.crowdHttpAuthenticator = new CrowdHttpAuthenticatorImpl(this.configuration.crowdClient, this.configuration.clientProperties, this.configuration.tokenHelper);
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        if (null == this.configuration) {
            this.initializeConfiguration();
        }
        CrowdRememberMeServices ssoService = new CrowdRememberMeServices(this.configuration);
        CrowdAuthenticationManager crowdAuthenticationManager = new CrowdAuthenticationManager(this.configuration);
        CrowdUserDetailsService crowdUserDetails = new CrowdUserDetailsService(this.configuration);
        return new SecurityRealm.SecurityComponents((AuthenticationManager)crowdAuthenticationManager, (UserDetailsService)crowdUserDetails, (RememberMeServices)ssoService);
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        SecurityRealm realm = Hudson.getInstance().getSecurityRealm();
        if (realm instanceof CrowdSecurityRealm && realm.getSecurityComponents().rememberMe instanceof CrowdRememberMeServices) {
            ((CrowdRememberMeServices)realm.getSecurityComponents().rememberMe).logout((HttpServletRequest)req, (HttpServletResponse)rsp);
        }
        super.doLogout(req, rsp);
    }

    public Filter createFilter(FilterConfig filterConfig) throws ServletException {
        if (null == this.configuration) {
            this.initializeConfiguration();
        }
        Filter defaultFilter = super.createFilter(filterConfig);
        return new CrowdServletFilter(this, this.configuration, defaultFilter);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getSecurityComponents().userDetails.loadUserByUsername(username);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        try {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Trying to load group: " + groupname);
            }
            final Group crowdGroup = this.configuration.crowdClient.getGroup(groupname);
            return new GroupDetails(){

                public String getName() {
                    return crowdGroup.getName();
                }
            };
        }
        catch (GroupNotFoundException ex) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(ErrorMessages.groupNotFound(groupname));
            }
            throw new DataRetrievalFailureException(ErrorMessages.groupNotFound(groupname), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new DataRetrievalFailureException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new DataRetrievalFailureException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new DataRetrievalFailureException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
    }

    protected UserDetails authenticate(String pUsername, String pPassword) throws AuthenticationException {
        User user;
        if (!this.configuration.isGroupMember(pUsername)) {
            throw new InsufficientAuthenticationException(ErrorMessages.userNotValid(pUsername, this.configuration.allowedGroupNames));
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Authenticate user '" + pUsername + "' using password '" + (null != pPassword ? "<available>'" : "<not specified>'"));
            }
            user = this.configuration.crowdClient.authenticateUser(pUsername, pPassword);
        }
        catch (UserNotFoundException ex) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(ErrorMessages.userNotFound(pUsername));
            }
            throw new BadCredentialsException(ErrorMessages.userNotFound(pUsername), (Throwable)ex);
        }
        catch (ExpiredCredentialException ex) {
            LOG.warning(ErrorMessages.expiredCredentials(pUsername));
            throw new BadCredentialsException(ErrorMessages.expiredCredentials(pUsername), (Throwable)ex);
        }
        catch (InactiveAccountException ex) {
            LOG.warning(ErrorMessages.accountExpired(pUsername));
            throw new AccountExpiredException(ErrorMessages.accountExpired(pUsername), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new AuthenticationServiceException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new AuthenticationServiceException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new AuthenticationServiceException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        authorities.addAll(this.configuration.getAuthoritiesForUser(pUsername));
        return new CrowdUser(user, authorities);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public DescriptorImpl() {
            super(CrowdSecurityRealm.class);
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (0 == url.length()) {
                return FormValidation.error((String)ErrorMessages.specifyCrowdUrl());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApplicationName(@QueryParameter String applicationName) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (0 == applicationName.length()) {
                return FormValidation.error((String)ErrorMessages.specifyApplicationName());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String password) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (0 == password.length()) {
                return FormValidation.error((String)ErrorMessages.specifyApplicationPassword());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroup(@QueryParameter String group) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (0 == group.length()) {
                return FormValidation.error((String)ErrorMessages.specifyGroup());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSessionValidationInterval(@QueryParameter String sessionValidationInterval) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                if (0 == sessionValidationInterval.length() || Integer.valueOf(sessionValidationInterval) < 0) {
                    return FormValidation.error((String)ErrorMessages.specifySessionValidationInterval());
                }
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)ErrorMessages.specifySessionValidationInterval());
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String applicationName, @QueryParameter String password, @QueryParameter String group) {
            FormValidation formValidation;
            Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            Properties props = new Properties();
            props.setProperty("application.name", applicationName);
            props.setProperty("application.password", password);
            props.setProperty("crowd.server.url", url);
            props.setProperty("session.validationinterval", "5");
            CrowdConfigurationService configuration = new CrowdConfigurationService(group, false);
            configuration.clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)props);
            configuration.crowdClient = new RestCrowdClientFactory().newInstance(configuration.clientProperties);
            try {
                configuration.crowdClient.testConnection();
                for (String groupName : configuration.allowedGroupNames) {
                    if (configuration.isGroupActive(groupName)) continue;
                    FormValidation formValidation2 = FormValidation.error((String)ErrorMessages.groupNotFound(groupName));
                    return formValidation2;
                }
                FormValidation i$ = FormValidation.ok();
                return i$;
            }
            catch (InvalidAuthenticationException ex) {
                log.log(Level.WARNING, ErrorMessages.invalidAuthentication(), ex);
                formValidation = FormValidation.error((String)ErrorMessages.invalidAuthentication());
                return formValidation;
            }
            catch (ApplicationPermissionException ex) {
                log.log(Level.WARNING, ErrorMessages.applicationPermission(), ex);
                formValidation = FormValidation.error((String)ErrorMessages.applicationPermission());
                return formValidation;
            }
            catch (OperationFailedException ex) {
                log.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
                formValidation = FormValidation.error((String)ErrorMessages.operationFailed());
                return formValidation;
            }
            finally {
                configuration.crowdClient.shutdown();
            }
        }

        public String getDisplayName() {
            return "Crowd 2";
        }
    }
}

