/*
 * Decompiled with CFR 0.152.
 */
package de.theit.jenkins.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import de.theit.jenkins.crowd.ErrorMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdConfigurationService {
    private static final Logger LOG = Logger.getLogger(CrowdConfigurationService.class.getName());
    private static final int MAX_GROUPS = 500;
    ClientProperties clientProperties;
    CrowdClient crowdClient;
    CrowdHttpTokenHelper tokenHelper;
    CrowdHttpAuthenticator crowdHttpAuthenticator;
    Collection<String> allowedGroupNames;
    private boolean nestedGroups;

    public CrowdConfigurationService(String pGroupNames, boolean pNestedGroups) {
        if (0 == pGroupNames.length()) {
            throw new IllegalArgumentException(ErrorMessages.specifyGroup());
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Groups given for Crowd configuration service: " + pGroupNames);
        }
        this.allowedGroupNames = new ArrayList();
        for (String group : pGroupNames.split("[,\\s]")) {
            if (null == group || group.trim().length() <= 0) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("-> adding allowed group name: " + group);
            }
            this.allowedGroupNames.add(group);
        }
        if (this.allowedGroupNames.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.specifyGroup());
        }
        this.nestedGroups = pNestedGroups;
    }

    public boolean isGroupMember(String username) {
        boolean retval = false;
        try {
            String group;
            Iterator i$ = this.allowedGroupNames.iterator();
            while (i$.hasNext() && !(retval = this.isGroupMember(username, group = (String)i$.next()))) {
            }
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
        return retval;
    }

    private boolean isGroupMember(String username, String group) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        boolean retval = false;
        if (this.isGroupActive(group)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Checking group membership for user '" + username + "' and group '" + group + "'...");
            }
            if (this.crowdClient.isUserDirectGroupMember(username, group)) {
                retval = true;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("=> user is a direct group member");
                }
            } else if (this.nestedGroups && this.crowdClient.isUserNestedGroupMember(username, group)) {
                retval = true;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("=> user is a nested group member");
                }
            }
        }
        return retval;
    }

    public boolean isGroupActive(String groupName) throws InvalidAuthenticationException, ApplicationPermissionException, OperationFailedException {
        boolean retval;
        block4: {
            retval = false;
            try {
                Group group;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Checking whether group is active: " + groupName);
                }
                if (null != (group = this.crowdClient.getGroup(groupName))) {
                    retval = group.isActive();
                }
            }
            catch (GroupNotFoundException ex) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine(ErrorMessages.groupNotFound((String)groupName));
            }
        }
        return retval;
    }

    public Collection<GrantedAuthority> getAuthoritiesForUser(String username) {
        List groups;
        int index;
        TreeSet<GrantedAuthority> authorities = new TreeSet<GrantedAuthority>((Comparator<GrantedAuthority>)new /* Unavailable Anonymous Inner Class!! */);
        HashSet<String> groupNames = new HashSet<String>();
        try {
            index = 0;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Retrieve list of groups with direct membership for user '" + username + "'...");
            }
            while (true) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Fetching groups [" + index + "..." + (index + 500 - 1) + "]...");
                }
                if (null != (groups = this.crowdClient.getGroupsForUser(username, index, 500)) && !groups.isEmpty()) {
                    for (Group group : groups) {
                        if (!group.isActive()) continue;
                        groupNames.add(group.getName());
                    }
                    index += 500;
                    continue;
                }
                break;
            }
        }
        catch (UserNotFoundException ex) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(ErrorMessages.userNotFound((String)username));
            }
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
        if (this.nestedGroups) {
            try {
                index = 0;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Retrieve list of groups with direct membership for user '" + username + "'...");
                }
                while (true) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Fetching groups [" + index + "..." + (index + 500 - 1) + "]...");
                    }
                    if (null != (groups = this.crowdClient.getGroupsForNestedUser(username, index, 500)) && !groups.isEmpty()) {
                        for (Group group : groups) {
                            if (!group.isActive()) continue;
                            groupNames.add(group.getName());
                        }
                        index += 500;
                        continue;
                    }
                    break;
                }
            }
            catch (UserNotFoundException ex) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info(ErrorMessages.userNotFound((String)username));
                }
            }
            catch (InvalidAuthenticationException ex) {
                LOG.warning(ErrorMessages.invalidAuthentication());
            }
            catch (ApplicationPermissionException ex) {
                LOG.warning(ErrorMessages.applicationPermission());
            }
            catch (OperationFailedException ex) {
                LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            }
        }
        for (String str : groupNames) {
            authorities.add((GrantedAuthority)new GrantedAuthorityImpl(str));
        }
        return authorities;
    }
}

