/*
 * Decompiled with CFR 0.152.
 */
package de.theit.jenkins.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import de.theit.jenkins.crowd.CrowdConfigurationService;
import de.theit.jenkins.crowd.CrowdUser;
import de.theit.jenkins.crowd.ErrorMessages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CrowdUserDetailsService
implements UserDetailsService {
    private static final Logger LOG = Logger.getLogger(CrowdUserDetailsService.class.getName());
    private CrowdConfigurationService configuration;

    public CrowdUserDetailsService(CrowdConfigurationService pConfiguration) {
        this.configuration = pConfiguration;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        User user;
        if (!this.configuration.isGroupMember(username)) {
            throw new DataRetrievalFailureException(ErrorMessages.userNotValid((String)username, (Collection)this.configuration.allowedGroupNames));
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Loading user object from the remote Crowd server...");
            }
            user = this.configuration.crowdClient.getUser(username);
        }
        catch (UserNotFoundException ex) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(ErrorMessages.userNotFound((String)username));
            }
            throw new UsernameNotFoundException(ErrorMessages.userNotFound((String)username), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new DataRetrievalFailureException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new DataRetrievalFailureException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new DataRetrievalFailureException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        authorities.addAll(this.configuration.getAuthoritiesForUser(username));
        return new CrowdUser(user, authorities);
    }
}

