/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.EditDistance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonHelper {
    public static Item getItem(String pathName, ItemGroup context) {
        Hudson hudson = Hudson.getInstance();
        if (context == null) {
            context = hudson;
        }
        if (pathName == null) {
            return null;
        }
        if (pathName.startsWith("/")) {
            return hudson.getItemByFullName(pathName);
        }
        ItemGroup ctx = context;
        StringTokenizer tokens = new StringTokenizer(pathName, "/");
        while (tokens.hasMoreTokens()) {
            String s = tokens.nextToken();
            if (s.equals("..")) {
                if (ctx instanceof Item) {
                    ctx = ((Item)ctx).getParent();
                    continue;
                }
                ctx = null;
                break;
            }
            if (s.equals(".")) continue;
            if (ctx instanceof ItemGroup) {
                ItemGroup g = ctx;
                Item i = g.getItem(s);
                if (i == null || !i.hasPermission(Item.READ)) {
                    ctx = null;
                    break;
                }
                ctx = i;
                continue;
            }
            return null;
        }
        if (ctx instanceof Item) {
            return (Item)ctx;
        }
        return hudson.getItemByFullName(pathName);
    }

    public static final Item getItem(String pathName, Item context) {
        return HudsonHelper.getItem(pathName, context != null ? context.getParent() : null);
    }

    public static final <T extends Item> T getItem(String pathName, ItemGroup context, Class<T> type) {
        Item r = HudsonHelper.getItem(pathName, context);
        if (type.isInstance(r)) {
            return (T)((Item)type.cast(r));
        }
        return null;
    }

    public static final <T extends Item> T getItem(String pathName, Item item, Class<T> type) {
        Item r = HudsonHelper.getItem(pathName, item.getParent());
        if (type.isInstance(r)) {
            return (T)((Item)type.cast(r));
        }
        return null;
    }

    public static AbstractProject findNearest(String name) {
        return HudsonHelper.findNearest(name, (ItemGroup)Hudson.getInstance());
    }

    public static AbstractProject findNearest(String name, ItemGroup context) {
        List projects = Hudson.getInstance().getAllItems(AbstractProject.class);
        String[] names = new String[projects.size()];
        for (int i = 0; i < projects.size(); ++i) {
            names[i] = HudsonHelper.getRelativeNameFrom((Item)projects.get(i), context);
        }
        String nearest = EditDistance.findNearest((String)name, (String[])names);
        return (AbstractProject)HudsonHelper.getItem(nearest, context);
    }

    public static String getRelativeNameFrom(Item item, ItemGroup p) {
        HashMap<ItemGroup, Integer> parents = new HashMap<ItemGroup, Integer>();
        int depth = 0;
        while (p != null) {
            parents.put(p, depth++);
            if (p instanceof Item) {
                p = ((Item)p).getParent();
                continue;
            }
            p = null;
        }
        StringBuilder buf = new StringBuilder();
        Item i = item;
        while (true) {
            if (buf.length() > 0) {
                buf.insert(0, '/');
            }
            buf.insert(0, i.getName());
            ItemGroup g = i.getParent();
            Integer d = (Integer)parents.get(g);
            if (d != null) {
                String s = "";
                for (int j = d.intValue(); j > 0; --j) {
                    s = s + "../";
                }
                return s + buf;
            }
            if (!(g instanceof Item)) break;
            i = (Item)g;
        }
        return null;
    }

    public static <T extends Item> List<T> fromNameList(ItemGroup context, String list, Class<T> type) {
        ArrayList<T> r = new ArrayList<T>();
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            String fullName = tokens.nextToken().trim();
            T item = HudsonHelper.getItem(fullName, context, type);
            if (item == null) continue;
            r.add(item);
        }
        return r;
    }
}

