/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.plugins.dry.Messages;
import hudson.util.FormValidation;

public class ThresholdValidation {
    static final int DEFAULT_HIGH_THRESHOLD = 50;
    static final int DEFAULT_NORMAL_THRESHOLD = 25;

    public FormValidation validateHigh(String highThreshold, String normalThreshold) {
        return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_HighThreshold());
    }

    public FormValidation validateNormal(String highThreshold, String normalThreshold) {
        return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_NormalThreshold());
    }

    private FormValidation validate(String highThreshold, String normalThreshold, String message) {
        try {
            int high = Integer.parseInt(highThreshold);
            int normal = Integer.parseInt(normalThreshold);
            if (this.isValid(normal, high)) {
                return FormValidation.ok();
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return FormValidation.error((String)message);
    }

    public int getHighThreshold(int normalThreshold, int highThreshold) {
        if (!this.isValid(normalThreshold, highThreshold)) {
            return 50;
        }
        return highThreshold;
    }

    private boolean isValid(int normalThreshold, int highThreshold) {
        return highThreshold > 0 && normalThreshold > 0 && highThreshold > normalThreshold;
    }

    public int getNormalThreshold(int normalThreshold, int highThreshold) {
        if (!this.isValid(normalThreshold, highThreshold)) {
            return 25;
        }
        return normalThreshold;
    }
}

