/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.parser;

import com.google.common.collect.Sets;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.dry.parser.DuplicateCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDryParser
implements AnnotationParser {
    private static final long serialVersionUID = 6328121785037117886L;
    private final int highThreshold;
    private final int normalThreshold;

    public AbstractDryParser(int highThreshold, int normalThreshold) {
        this.highThreshold = highThreshold;
        this.normalThreshold = normalThreshold;
    }

    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        FileInputStream inputStream;
        block5: {
            inputStream = null;
            inputStream = new FileInputStream(file);
            if (!this.accepts((InputStream)inputStream)) break block5;
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = new FileInputStream(file);
            HashSet warnings = Sets.newHashSet();
            warnings.addAll(this.parse((InputStream)inputStream, moduleName));
            HashSet hashSet = warnings;
            IOUtils.closeQuietly((InputStream)inputStream);
            return hashSet;
        }
        try {
            try {
                throw new IOException("Can't parse CPD file " + file.getAbsolutePath());
            }
            catch (IOException exception) {
                throw new InvocationTargetException(exception);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
    }

    protected abstract Collection<DuplicateCode> parse(InputStream var1, String var2) throws InvocationTargetException;

    protected abstract boolean accepts(InputStream var1);

    protected Priority getPriority(int lines) {
        if (lines >= this.highThreshold) {
            return Priority.HIGH;
        }
        if (lines >= this.normalThreshold) {
            return Priority.NORMAL;
        }
        return Priority.LOW;
    }
}

