/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.parser.simian;

import hudson.plugins.analysis.util.PackageDetectors;
import hudson.plugins.dry.parser.AbstractDryParser;
import hudson.plugins.dry.parser.DuplicateCode;
import hudson.plugins.dry.parser.simian.Block;
import hudson.plugins.dry.parser.simian.Set;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimianParser
extends AbstractDryParser {
    private static final long serialVersionUID = 6507147028628714706L;

    public SimianParser(int highThreshold, int normalThreshold) {
        super(highThreshold, normalThreshold);
    }

    public boolean accepts(InputStream file) {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(SimianParser.class.getClassLoader());
            String duplicationXPath = "*/simian";
            digester.addObjectCreate(duplicationXPath, String.class);
            Object result = digester.parse(file);
            if (result instanceof String) {
                return true;
            }
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    public Collection<DuplicateCode> parse(InputStream file, String moduleName) throws InvocationTargetException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(SimianParser.class.getClassLoader());
            ArrayList duplications = new ArrayList();
            digester.push(duplications);
            String duplicationXPath = "*/simian/check/set";
            digester.addObjectCreate(duplicationXPath, Set.class);
            digester.addSetProperties(duplicationXPath);
            digester.addSetNext(duplicationXPath, "add");
            String fileXPath = duplicationXPath + "/block";
            digester.addObjectCreate(fileXPath, Block.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addBlock", Block.class.getName());
            Object result = digester.parse(file);
            if (result != duplications) {
                throw new SAXException("Input stream is not a valid Simian file.");
            }
            return this.convert(duplications, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private Collection<DuplicateCode> convert(List<Set> duplications, String moduleName) {
        ArrayList<DuplicateCode> annotations = new ArrayList<DuplicateCode>();
        for (Set duplication : duplications) {
            ArrayList<DuplicateCode> codeBlocks = new ArrayList<DuplicateCode>();
            for (Block file : duplication.getBlocks()) {
                DuplicateCode annotation = new DuplicateCode(this.getPriority(duplication.getLineCount()), file.getStartLineNumber(), duplication.getLineCount(), file.getSourceFile());
                annotation.setModuleName(moduleName);
                codeBlocks.add(annotation);
            }
            for (DuplicateCode block : codeBlocks) {
                block.linkTo(codeBlocks);
                String packageName = PackageDetectors.detectPackageName((String)block.getFileName());
                block.setPackageName(packageName);
            }
            annotations.addAll(codeBlocks);
        }
        return annotations;
    }
}

