/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import com.thoughtworks.xstream.XStream;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.dry.DryDescriptor;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.dry.Messages;
import hudson.plugins.dry.parser.DuplicateCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        this(build, defaultEncoding, result, DryResultAction.class);
    }

    protected DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, Class<? extends ResultAction<DryResult>> actionType) {
        this(build, new BuildHistory(build, actionType), result, defaultEncoding, true);
    }

    DryResult(AbstractBuild<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding, boolean canSerialize) {
        super(build, history, result, defaultEncoding);
        if (canSerialize) {
            this.serializeAnnotations(result.getAnnotations());
        }
    }

    public String getHeader() {
        return Messages.DRY_ResultAction_Header();
    }

    protected void configure(XStream xstream) {
        xstream.alias("dry", DuplicateCode.class);
    }

    public String getSummary() {
        return Messages.DRY_ProjectAction_Name() + ": " + DryResult.createDefaultSummary((String)DryDescriptor.RESULT_URL, (int)this.getNumberOfAnnotations(), (int)this.getNumberOfModules());
    }

    protected String createDeltaMessage() {
        return DryResult.createDefaultDeltaMessage((String)DryDescriptor.RESULT_URL, (int)this.getNumberOfNewWarnings(), (int)this.getNumberOfFixedWarnings());
    }

    protected String getSerializationFileName() {
        return "dry-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.DRY_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return DryResultAction.class;
    }
}

