/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.FilePath;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.dry.DryMavenResultAction;
import hudson.plugins.dry.DryProjectAction;
import hudson.plugins.dry.DryReporterResult;
import hudson.plugins.dry.DryResult;
import hudson.plugins.dry.ThresholdValidation;
import hudson.plugins.dry.parser.DuplicationParserRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryReporter
extends HealthAwareReporter<DryResult> {
    private static final long serialVersionUID = 2272875032054063496L;
    private static final String PLUGIN_NAME = "DRY";
    private static final ThresholdValidation THRESHOLD_VALIDATION = new ThresholdValidation();
    private static final String DEFAULT_DRY_XML_FILE = "cpd.xml";
    private final int highThreshold;
    private final int normalThreshold;

    @DataBoundConstructor
    public DryReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean useStableBuildAsReference, boolean canComputeNew, int highThreshold, int normalThreshold) {
        super(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, useStableBuildAsReference, canComputeNew, PLUGIN_NAME);
        this.highThreshold = highThreshold;
        this.normalThreshold = normalThreshold;
    }

    public int getHighThreshold() {
        return THRESHOLD_VALIDATION.getHighThreshold(this.normalThreshold, this.highThreshold);
    }

    public int getNormalThreshold() {
        return THRESHOLD_VALIDATION.getNormalThreshold(this.normalThreshold, this.highThreshold);
    }

    protected boolean acceptGoal(String goal) {
        return "cpd".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilesParser dryCollector = new FilesParser(PLUGIN_NAME, DEFAULT_DRY_XML_FILE, (AnnotationParser)new DuplicationParserRegistry(this.getNormalThreshold(), this.getHighThreshold(), this.getDefaultEncoding()), this.getModuleName(pom));
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)dryCollector);
    }

    protected DryResult createResult(MavenBuild build, ParserResult project) {
        return new DryReporterResult((AbstractBuild)build, this.getDefaultEncoding(), project, this.useOnlyStableBuildsAsReference());
    }

    protected MavenAggregatedReport createMavenAggregatedReport(MavenBuild build, DryResult result) {
        return new DryMavenResultAction((AbstractBuild)build, (HealthDescriptor)this, this.getDefaultEncoding(), result);
    }

    public List<DryProjectAction> getProjectActions(MavenModule module) {
        return Collections.singletonList(new DryProjectAction((AbstractProject)module, this.getResultActionClass()));
    }

    protected Class<DryMavenResultAction> getResultActionClass() {
        return DryMavenResultAction.class;
    }
}

