/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.parser;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.util.ContextHashCode;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.dry.parser.AbstractDryParser;
import hudson.plugins.dry.parser.DuplicateCode;
import hudson.plugins.dry.parser.cpd.CpdParser;
import hudson.plugins.dry.parser.simian.SimianParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.xerces.parsers.SAXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicationParserRegistry
implements AnnotationParser {
    private static final long serialVersionUID = -8114361417348412242L;
    @SuppressWarnings(value={"SE"})
    private final List<AbstractDryParser> parsers = new ArrayList();
    private String workspacePath;
    private final String defaultEncoding;
    private static final String SAX_DRIVER_PROPERTY = "org.xml.sax.driver";

    public DuplicationParserRegistry(int normalThreshold, int highThreshold, String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        this.parsers.add(new CpdParser(highThreshold, normalThreshold));
        this.parsers.add(new SimianParser(highThreshold, normalThreshold));
    }

    public DuplicationParserRegistry(int normalThreshold, int highThreshold, String workspacePath, String defaultEncoding) {
        this(normalThreshold, highThreshold, defaultEncoding);
        this.workspacePath = workspacePath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        HashSet hashSet;
        FileInputStream inputStream;
        String oldProperty;
        block10: {
            oldProperty = System.getProperty(SAX_DRIVER_PROPERTY);
            if (oldProperty != null) {
                System.setProperty(SAX_DRIVER_PROPERTY, SAXParser.class.getName());
            }
            inputStream = null;
            try {
                for (AbstractDryParser parser : this.parsers) {
                    if (!parser.accepts((InputStream)(inputStream = new FileInputStream(file)))) continue;
                    IOUtils.closeQuietly((InputStream)inputStream);
                    inputStream = new FileInputStream(file);
                    Collection result = parser.parse((InputStream)inputStream, moduleName);
                    this.createLinkNames(result);
                    HashSet warnings = Sets.newHashSet();
                    warnings.addAll(result);
                    ContextHashCode hashCode = new ContextHashCode();
                    for (FileAnnotation duplication : warnings) {
                        duplication.setContextHashCode((long)hashCode.create(duplication.getFileName(), duplication.getPrimaryLineNumber(), this.defaultEncoding));
                    }
                    hashSet = warnings;
                    break block10;
                }
                throw new IOException("No parser found for duplicated code results file " + file.getAbsolutePath());
            }
            catch (IOException exception) {
                throw new InvocationTargetException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                if (oldProperty == null) throw throwable;
                System.setProperty(SAX_DRIVER_PROPERTY, oldProperty);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        if (oldProperty == null) return hashSet;
        System.setProperty(SAX_DRIVER_PROPERTY, oldProperty);
        return hashSet;
    }

    private void createLinkNames(Collection<DuplicateCode> result) {
        if (this.workspacePath != null) {
            for (DuplicateCode duplication : result) {
                duplication.setPathName(this.workspacePath);
            }
        }
    }
}

