// CHECKSTYLE:OFF

package hudson.plugins.findbugs;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * FindBugs warnings trend graph (new vs. fixed)
     * 
     */
    public static String Portlet_WarningsNewVsFixedGraph() {
        return holder.format("Portlet.WarningsNewVsFixedGraph");
    }

    /**
     * FindBugs warnings trend graph (new vs. fixed)
     * 
     */
    public static Localizable _Portlet_WarningsNewVsFixedGraph() {
        return new Localizable(holder, "Portlet.WarningsNewVsFixedGraph");
    }

    /**
     * at {0}
     * 
     */
    public static String FindBugs_Bug_cloudInfo_firstSeen(Object arg1) {
        return holder.format("FindBugs.Bug.cloudInfo.firstSeen", arg1);
    }

    /**
     * at {0}
     * 
     */
    public static Localizable _FindBugs_Bug_cloudInfo_firstSeen(Object arg1) {
        return new Localizable(holder, "FindBugs.Bug.cloudInfo.firstSeen", arg1);
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static String FindBugs_ProjectAction_Name() {
        return holder.format("FindBugs.ProjectAction.Name");
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_ProjectAction_Name() {
        return new Localizable(holder, "FindBugs.ProjectAction.Name");
    }

    /**
     * FindBugs warnings per project
     * 
     */
    public static String Portlet_WarningsTable() {
        return holder.format("Portlet.WarningsTable");
    }

    /**
     * FindBugs warnings per project
     * 
     */
    public static Localizable _Portlet_WarningsTable() {
        return new Localizable(holder, "Portlet.WarningsTable");
    }

    /**
     * First seen {0} days ago
     * 
     */
    public static String FindBugs_Bug_cloudInfo_seenAt_plural(Object arg1) {
        return holder.format("FindBugs.Bug.cloudInfo.seenAt.plural", arg1);
    }

    /**
     * First seen {0} days ago
     * 
     */
    public static Localizable _FindBugs_Bug_cloudInfo_seenAt_plural(Object arg1) {
        return new Localizable(holder, "FindBugs.Bug.cloudInfo.seenAt.plural", arg1);
    }

    /**
     * FindBugs Cloud
     * 
     */
    public static String FindBugs_Bug_cloudInfo_title() {
        return holder.format("FindBugs.Bug.cloudInfo.title");
    }

    /**
     * FindBugs Cloud
     * 
     */
    public static Localizable _FindBugs_Bug_cloudInfo_title() {
        return new Localizable(holder, "FindBugs.Bug.cloudInfo.title");
    }

    /**
     * Skipping FindBugs file {0} because we have no permission to read the file.
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_NoPermission(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.NoPermission", arg1);
    }

    /**
     * Skipping FindBugs file {0} because we have no permission to read the file.
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_NoPermission(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.NoPermission", arg1);
    }

    /**
     * FindBugs Cloud Comments
     * 
     */
    public static String FindBugs_EvaluationsGraph_title() {
        return holder.format("FindBugs.EvaluationsGraph.title");
    }

    /**
     * FindBugs Cloud Comments
     * 
     */
    public static Localizable _FindBugs_EvaluationsGraph_title() {
        return new Localizable(holder, "FindBugs.EvaluationsGraph.title");
    }

    /**
     * Skipping FindBugs file {0} because it''s empty.
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_EmptyFile(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.EmptyFile", arg1);
    }

    /**
     * Skipping FindBugs file {0} because it''s empty.
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_EmptyFile(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.EmptyFile", arg1);
    }

    /**
     * First seen yesterday
     * 
     */
    public static String FindBugs_Bug_cloudInfo_seenAt_singular() {
        return holder.format("FindBugs.Bug.cloudInfo.seenAt.singular");
    }

    /**
     * First seen yesterday
     * 
     */
    public static Localizable _FindBugs_Bug_cloudInfo_seenAt_singular() {
        return new Localizable(holder, "FindBugs.Bug.cloudInfo.seenAt.singular");
    }

    /**
     * Publish FindBugs analysis results
     * 
     */
    public static String FindBugs_Publisher_Name() {
        return holder.format("FindBugs.Publisher.Name");
    }

    /**
     * Publish FindBugs analysis results
     * 
     */
    public static Localizable _FindBugs_Publisher_Name() {
        return new Localizable(holder, "FindBugs.Publisher.Name");
    }

    /**
     * FindBugs: one warning found.
     * 
     */
    public static String FindBugs_ResultAction_HealthReportSingleItem() {
        return holder.format("FindBugs.ResultAction.HealthReportSingleItem");
    }

    /**
     * FindBugs: one warning found.
     * 
     */
    public static Localizable _FindBugs_ResultAction_HealthReportSingleItem() {
        return new Localizable(holder, "FindBugs.ResultAction.HealthReportSingleItem");
    }

    /**
     * New FindBugs Warnings
     * 
     */
    public static String FindBugs_NewWarnings_Detail_header() {
        return holder.format("FindBugs.NewWarnings.Detail.header");
    }

    /**
     * New FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_NewWarnings_Detail_header() {
        return new Localizable(holder, "FindBugs.NewWarnings.Detail.header");
    }

    /**
     *  1 comment
     * 
     */
    public static String FindBugs_Bug_cloudInfo_reviewer_singular() {
        return holder.format("FindBugs.Bug.cloudInfo.reviewer.singular");
    }

    /**
     *  1 comment
     * 
     */
    public static Localizable _FindBugs_Bug_cloudInfo_reviewer_singular() {
        return new Localizable(holder, "FindBugs.Bug.cloudInfo.reviewer.singular");
    }

    /**
     * FindBugs warnings trend graph (priority distribution)
     * 
     */
    public static String Portlet_WarningsPriorityGraph() {
        return holder.format("Portlet.WarningsPriorityGraph");
    }

    /**
     * FindBugs warnings trend graph (priority distribution)
     * 
     */
    public static Localizable _Portlet_WarningsPriorityGraph() {
        return new Localizable(holder, "Portlet.WarningsPriorityGraph");
    }

    /**
     * FindBugs file {0} was either created with the out-dated version 1.1.1 of the maven-findbugs-plugin or you did not specify the correct results file (findbugsXml.xml and not findbugs.xml).
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_OldMavenPlugin(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.OldMavenPlugin", arg1);
    }

    /**
     * FindBugs file {0} was either created with the out-dated version 1.1.1 of the maven-findbugs-plugin or you did not specify the correct results file (findbugsXml.xml and not findbugs.xml).
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_OldMavenPlugin(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.OldMavenPlugin", arg1);
    }

    /**
     * Fixed FindBugs Warnings
     * 
     */
    public static String FindBugs_FixedWarnings_Detail_header() {
        return holder.format("FindBugs.FixedWarnings.Detail.header");
    }

    /**
     * Fixed FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_FixedWarnings_Detail_header() {
        return new Localizable(holder, "FindBugs.FixedWarnings.Detail.header");
    }

    /**
     * FindBugs Trend
     * 
     */
    public static String FindBugs_Trend_Name() {
        return holder.format("FindBugs.Trend.Name");
    }

    /**
     * FindBugs Trend
     * 
     */
    public static Localizable _FindBugs_Trend_Name() {
        return new Localizable(holder, "FindBugs.Trend.Name");
    }

    /**
     * No description available.
     * 
     */
    public static String FindBugs_Publisher_NoMessageFoundText() {
        return holder.format("FindBugs.Publisher.NoMessageFoundText");
    }

    /**
     * No description available.
     * 
     */
    public static Localizable _FindBugs_Publisher_NoMessageFoundText() {
        return new Localizable(holder, "FindBugs.Publisher.NoMessageFoundText");
    }

    /**
     * {0} comments
     * 
     */
    public static String FindBugs_Bug_cloudInfo_reviewer_plural(Object arg1) {
        return holder.format("FindBugs.Bug.cloudInfo.reviewer.plural", arg1);
    }

    /**
     * {0} comments
     * 
     */
    public static Localizable _FindBugs_Bug_cloudInfo_reviewer_plural(Object arg1) {
        return new Localizable(holder, "FindBugs.Bug.cloudInfo.reviewer.plural", arg1);
    }

    /**
     * FindBugs: no warnings found.
     * 
     */
    public static String FindBugs_ResultAction_HealthReportNoItem() {
        return holder.format("FindBugs.ResultAction.HealthReportNoItem");
    }

    /**
     * FindBugs: no warnings found.
     * 
     */
    public static Localizable _FindBugs_ResultAction_HealthReportNoItem() {
        return new Localizable(holder, "FindBugs.ResultAction.HealthReportNoItem");
    }

    /**
     * FindBugs: {0} warnings found.
     * 
     */
    public static String FindBugs_ResultAction_HealthReportMultipleItem(Object arg1) {
        return holder.format("FindBugs.ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * FindBugs: {0} warnings found.
     * 
     */
    public static Localizable _FindBugs_ResultAction_HealthReportMultipleItem(Object arg1) {
        return new Localizable(holder, "FindBugs.ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * Parsing of file {0} failed due to an exception:
     * 
     */
    public static String FindBugs_FindBugsCollector_Error_Exception(Object arg1) {
        return holder.format("FindBugs.FindBugsCollector.Error.Exception", arg1);
    }

    /**
     * Parsing of file {0} failed due to an exception:
     * 
     */
    public static Localizable _FindBugs_FindBugsCollector_Error_Exception(Object arg1) {
        return new Localizable(holder, "FindBugs.FindBugsCollector.Error.Exception", arg1);
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static String FindBugs_Detail_header() {
        return holder.format("FindBugs.Detail.header");
    }

    /**
     * FindBugs Warnings
     * 
     */
    public static Localizable _FindBugs_Detail_header() {
        return new Localizable(holder, "FindBugs.Detail.header");
    }

    /**
     * FindBugs warnings trend graph (totals)
     * 
     */
    public static String Portlet_WarningsTotalsGraph() {
        return holder.format("Portlet.WarningsTotalsGraph");
    }

    /**
     * FindBugs warnings trend graph (totals)
     * 
     */
    public static Localizable _Portlet_WarningsTotalsGraph() {
        return new Localizable(holder, "Portlet.WarningsTotalsGraph");
    }

}
