/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.Plugin;
import hudson.plugins.analysis.views.DetailFactory;
import hudson.plugins.findbugs.FindBugsDetailFactory;
import hudson.plugins.findbugs.FindBugsMavenResultAction;
import hudson.plugins.findbugs.FindBugsMessages;
import hudson.plugins.findbugs.FindBugsResultAction;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecution;
import org.xml.sax.SAXException;

public class FindBugsPlugin
extends Plugin {
    public void start() throws IOException, SAXException {
        FindBugsMessages.getInstance().initialize();
        FindBugsDetailFactory detailBuilder = new FindBugsDetailFactory();
        DetailFactory.addDetailBuilder(FindBugsResultAction.class, (DetailFactory)detailBuilder);
        DetailFactory.addDetailBuilder(FindBugsMavenResultAction.class, (DetailFactory)detailBuilder);
    }

    public static boolean isFindBugs2x(MojoExecution mojoExecution) {
        try {
            String[] versions = StringUtils.split((String)mojoExecution.getVersion(), (String)".");
            if (versions.length > 1) {
                int major = Integer.parseInt(versions[0]);
                int minor = Integer.parseInt(versions[1]);
                return major > 2 || major == 2 && minor >= 4;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

