/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ConnectionListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritConnectionConfig;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritDefaultValues;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.GerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeMerged;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.DraftPublished;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.RefUpdated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.Authentication;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshAuthenticationException;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnectException;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnection;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnectionFactory;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.Coordinator;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.EventThread;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.GerritEventWork;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.StreamEventsStringWork;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.Work;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritHandler
extends Thread
implements Coordinator {
    public static final int CONNECT_SLEEP = 2000;
    private static final String CMD_STREAM_EVENTS = "gerrit stream-events";
    private static final String GERRIT_VERSION_PREFIX = "gerrit version ";
    protected static final int PAUSE_SECOND = 1000;
    protected static final int BRUTE_FORCE_TRIES = 10;
    private static final Logger logger = LoggerFactory.getLogger(GerritHandler.class);
    private BlockingQueue<Work> workQueue;
    private String gerritHostName;
    private int gerritSshPort;
    private Authentication authentication;
    private int numberOfWorkerThreads;
    private final Set<GerritEventListener> gerritEventListeners = new CopyOnWriteArraySet<GerritEventListener>();
    private final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final List<EventThread> workers;
    private SshConnection sshConnection;
    private boolean shutdownInProgress = false;
    private final Object shutdownInProgressSync = new Object();
    private boolean connecting = false;
    private boolean connected = false;
    private String gerritVersion = null;

    public GerritHandler() {
        this("", 29418, new Authentication(GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE, "", GerritDefaultValues.DEFAULT_GERRIT_AUTH_KEY_FILE_PASSWORD), 3);
    }

    public GerritHandler(String gerritHostName, int gerritSshPort, Authentication authentication) {
        this(gerritHostName, gerritSshPort, authentication, 3);
    }

    public GerritHandler(GerritConnectionConfig config) {
        this(config.getGerritHostName(), config.getGerritSshPort(), config.getGerritAuthentication(), config.getNumberOfReceivingWorkerThreads());
    }

    public GerritHandler(String gerritHostName, int gerritSshPort, Authentication authentication, int numberOfWorkerThreads) {
        super("Gerrit Events Reader");
        this.gerritHostName = gerritHostName;
        this.gerritSshPort = gerritSshPort;
        this.authentication = authentication;
        this.numberOfWorkerThreads = numberOfWorkerThreads;
        this.workQueue = new LinkedBlockingQueue<Work>();
        this.workers = new ArrayList<EventThread>(numberOfWorkerThreads);
        for (int i = 0; i < numberOfWorkerThreads; ++i) {
            this.workers.add(new EventThread(this, "Gerrit Worker EventThread_" + i));
        }
    }

    public String getGerritVersion() {
        return this.gerritVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Starting Up...");
        for (EventThread worker : this.workers) {
            worker.start();
        }
        do {
            this.sshConnection = this.connect();
            if (this.sshConnection == null) {
                for (EventThread worker : this.workers) {
                    worker.shutdown();
                }
                return;
            }
            BufferedReader br = null;
            try {
                logger.trace("Executing stream-events command.");
                Reader reader = this.sshConnection.executeCommandReader(CMD_STREAM_EVENTS);
                br = new BufferedReader(reader);
                String line = "";
                logger.info("Ready to receive data from Gerrit");
                this.notifyConnectionEstablished();
                do {
                    logger.debug("Data-line from Gerrit: {}", (Object)line);
                    if (line != null && line.length() > 0) {
                        try {
                            StreamEventsStringWork work = new StreamEventsStringWork(line);
                            logger.trace("putting work on queue: {}", (Object)work);
                            this.workQueue.put(work);
                        }
                        catch (InterruptedException ex) {
                            logger.warn("Interrupted while putting work on queue!", (Throwable)ex);
                        }
                    }
                    logger.trace("Reading next line.");
                } while ((line = br.readLine()) != null);
            }
            catch (IOException ex) {
                logger.error("Stream events command error. ", (Throwable)ex);
            }
            finally {
                logger.trace("Connection closed, ended read loop.");
                try {
                    this.sshConnection.disconnect();
                }
                catch (Exception ex) {
                    logger.warn("Error when disconnecting sshConnection.", (Throwable)ex);
                }
                this.sshConnection = null;
                this.notifyConnectionDown();
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {
                        logger.warn("Could not close events reader.", (Throwable)ex);
                    }
                }
            }
        } while (!this.isShutdownInProgress());
        for (EventThread worker : this.workers) {
            worker.shutdown();
        }
        logger.debug("End of GerritHandler Thread.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SshConnection connect() {
        this.connecting = true;
        while (true) {
            if (this.isShutdownInProgress()) {
                this.connecting = false;
                return null;
            }
            SshConnection ssh = null;
            try {
                logger.debug("Connecting...");
                ssh = SshConnectionFactory.getConnection(this.gerritHostName, this.gerritSshPort, this.authentication);
                this.notifyConnectionEstablished();
                this.connecting = false;
                this.gerritVersion = this.formatVersion(ssh.executeCommand("gerrit version"));
                logger.debug("connection seems ok, returning it.");
                return ssh;
            }
            catch (SshConnectException sshConEx) {
                logger.error("Could not connect to Gerrit server! Host: {} Port: {}", (Object)this.gerritHostName, (Object)this.gerritSshPort);
                logger.error(" User: {} KeyFile: {}", (Object)this.authentication.getUsername(), (Object)this.authentication.getPrivateKeyFile());
                logger.error("ConnectionException: ", (Throwable)sshConEx);
                this.notifyConnectionDown();
            }
            catch (SshAuthenticationException sshAuthEx) {
                logger.error("Could not authenticate to Gerrit server!\n\tUsername: {}\n\tKeyFile: {}\n\tPassword: {}", new Object[]{this.authentication.getUsername(), this.authentication.getPrivateKeyFile(), this.authentication.getPrivateKeyFilePassword()});
                logger.error("AuthenticationException: ", (Throwable)sshAuthEx);
                this.notifyConnectionDown();
            }
            catch (IOException ex) {
                logger.error("Could not connect to Gerrit server! Host: {} Port: {}", (Object)this.gerritHostName, (Object)this.gerritSshPort);
                logger.error(" User: {} KeyFile: {}", (Object)this.authentication.getUsername(), (Object)this.authentication.getPrivateKeyFile());
                logger.error("IOException: ", (Throwable)ex);
                this.notifyConnectionDown();
            }
            if (ssh != null) {
                logger.trace("Disconnecting bad connection.");
                try {
                    ssh.disconnect();
                }
                catch (Exception ex) {
                    logger.warn("Error when disconnecting bad connection.", (Throwable)ex);
                }
                finally {
                    ssh = null;
                }
            }
            if (this.isShutdownInProgress()) {
                this.connecting = false;
                return null;
            }
            logger.trace("Sleeping for a bit.");
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException ex) {
                logger.warn("Got interrupted while sleeping.", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private String formatVersion(String version) {
        if (version == null) {
            return version;
        }
        String[] split = version.split(GERRIT_VERSION_PREFIX);
        if (split.length < 2) {
            return version.trim();
        }
        return split[1].trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(GerritEventListener listener) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            if (!this.gerritEventListeners.add(listener)) {
                logger.warn("The listener was doubly-added: {}", (Object)listener);
            }
        }
    }

    @Deprecated
    public void addEventListeners(Map<Integer, GerritEventListener> listeners) {
        this.addEventListeners(listeners.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListeners(Collection<? extends GerritEventListener> listeners) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            this.gerritEventListeners.addAll(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(GerritEventListener listener) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            this.gerritEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GerritEventListener> removeAllEventListeners() {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            HashSet<GerritEventListener> listeners = new HashSet<GerritEventListener>(this.gerritEventListeners);
            this.gerritEventListeners.clear();
            return listeners;
        }
    }

    public int getEventListenersCount() {
        return this.gerritEventListeners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ConnectionListener listener) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            this.connectionListeners.add(listener);
            return this.connected;
        }
    }

    @Deprecated
    public void addConnectionListeners(Map<Integer, ConnectionListener> listeners) {
        this.addConnectionListeners(listeners.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListeners(Collection<? extends ConnectionListener> listeners) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            this.connectionListeners.addAll(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConnectionListener listener) {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            this.connectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ConnectionListener> removeAllConnectionListeners() {
        GerritHandler gerritHandler = this;
        synchronized (gerritHandler) {
            HashSet<ConnectionListener> listeners = new HashSet<ConnectionListener>(this.connectionListeners);
            this.connectionListeners.clear();
            return listeners;
        }
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getGerritHostName() {
        return this.gerritHostName;
    }

    public void setGerritHostName(String gerritHostName) {
        this.gerritHostName = gerritHostName;
    }

    public int getGerritSshPort() {
        return this.gerritSshPort;
    }

    public void setGerritSshPort(int gerritSshPort) {
        this.gerritSshPort = gerritSshPort;
    }

    public int getNumberOfWorkerThreads() {
        return this.numberOfWorkerThreads;
    }

    public void setNumberOfWorkerThreads(int numberOfWorkerThreads) {
        this.numberOfWorkerThreads = numberOfWorkerThreads;
    }

    @Override
    public BlockingQueue<Work> getWorkQueue() {
        return this.workQueue;
    }

    @Override
    public void notifyListeners(GerritEvent event) {
        if (event instanceof PatchsetCreated) {
            try {
                ((PatchsetCreated)event).fireTriggerScanStarting();
            }
            catch (Exception ex) {
                logger.error("Error when notifying LifecycleListeners. ", (Throwable)ex);
            }
        }
        for (GerritEventListener listener : this.gerritEventListeners) {
            try {
                this.notifyListener(listener, event);
            }
            catch (Exception ex) {
                logger.error("When notifying listener: {} about event: {}", (Object)listener, (Object)event);
                logger.error("Notify-error: ", (Throwable)ex);
            }
        }
        if (event instanceof PatchsetCreated) {
            try {
                ((PatchsetCreated)event).fireTriggerScanDone();
            }
            catch (Exception ex) {
                logger.error("Error when notifying LifecycleListeners. ", (Throwable)ex);
            }
        }
    }

    private void notifyListener(GerritEventListener listener, GerritEvent event) {
        logger.debug("Notifying listener {} of event {}", (Object)listener, (Object)event);
        try {
            if (event instanceof PatchsetCreated) {
                listener.gerritEvent((PatchsetCreated)event);
            } else if (event instanceof DraftPublished) {
                listener.gerritEvent((DraftPublished)event);
            } else if (event instanceof ChangeAbandoned) {
                listener.gerritEvent((ChangeAbandoned)event);
            } else if (event instanceof ChangeMerged) {
                listener.gerritEvent((ChangeMerged)event);
            } else if (event instanceof CommentAdded) {
                listener.gerritEvent((CommentAdded)event);
            } else if (event instanceof RefUpdated) {
                listener.gerritEvent((RefUpdated)event);
            } else {
                listener.gerritEvent(event);
            }
        }
        catch (Exception ex) {
            logger.error("Exception thrown during event handling.", (Throwable)ex);
        }
    }

    private void notifyListenerDefaultMethod(GerritEventListener listener, GerritEvent event) {
        try {
            listener.gerritEvent(event);
        }
        catch (Exception ex) {
            logger.error("Exception thrown during event handling.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setShutdownInProgress(boolean isIt) {
        Object object = this.shutdownInProgressSync;
        synchronized (object) {
            this.shutdownInProgress = isIt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdownInProgress() {
        Object object = this.shutdownInProgressSync;
        synchronized (object) {
            return this.shutdownInProgress;
        }
    }

    public void shutdown(boolean join) {
        if (this.sshConnection != null) {
            logger.info("Shutting down the ssh connection.");
            for (int i = 0; i < 10; ++i) {
                this.setShutdownInProgress(true);
                if (this.isShutdownInProgress()) break;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.debug("Interrupted while pausing in the shutdown flag set.");
                }
            }
            if (!this.isShutdownInProgress()) {
                throw new RuntimeException("Failed to set the shutdown flag!");
            }
            this.sshConnection.disconnect();
            if (join) {
                try {
                    this.join();
                }
                catch (InterruptedException ex) {
                    logger.warn("Got interrupted while waiting for shutdown.", (Throwable)ex);
                }
            }
        } else if (this.connecting) {
            this.setShutdownInProgress(true);
            if (join) {
                try {
                    this.join();
                }
                catch (InterruptedException ex) {
                    logger.warn("Got interrupted while waiting for shutdown.", (Throwable)ex);
                }
            }
        } else {
            logger.warn("Was told to shutdown without a connection.");
        }
    }

    protected void notifyConnectionDown() {
        this.connected = false;
        for (ConnectionListener listener : this.connectionListeners) {
            try {
                listener.connectionDown();
            }
            catch (Exception ex) {
                logger.error("ConnectionListener threw Exception. ", (Throwable)ex);
            }
        }
    }

    protected void notifyConnectionEstablished() {
        this.connected = true;
        for (ConnectionListener listener : this.connectionListeners) {
            try {
                listener.connectionEstablished();
            }
            catch (Exception ex) {
                logger.error("ConnectionListener threw Exception. ", (Throwable)ex);
            }
        }
    }

    public void triggerEvent(GerritEvent event) {
        logger.debug("Internally trigger event: {}", (Object)event);
        try {
            logger.trace("putting work on queue.");
            this.workQueue.put(new GerritEventWork(event));
        }
        catch (InterruptedException ex) {
            logger.error("Interrupted while putting work on queue!", (Throwable)ex);
        }
    }
}

