/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritConnectionConfig;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritQueryException;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.Authentication;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnection;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnectionFactory;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritQueryHandler {
    private static final Logger logger = LoggerFactory.getLogger(GerritQueryHandler.class);
    public static final String QUERY_COMMAND = "gerrit query";
    private final String gerritHostName;
    private final int gerritSshPort;
    private final Authentication authentication;

    public GerritQueryHandler(String gerritHostName, int gerritSshPort, Authentication authentication) {
        this.gerritHostName = gerritHostName;
        this.gerritSshPort = gerritSshPort;
        this.authentication = authentication;
    }

    public GerritQueryHandler(GerritConnectionConfig config) {
        this(config.getGerritHostName(), config.getGerritSshPort(), config.getGerritAuthentication());
    }

    public List<JSONObject> queryJava(String queryString) throws SshException, IOException, GerritQueryException {
        return this.queryJava(queryString, true, true, false);
    }

    public List<JSONObject> queryJava(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles) throws SshException, IOException, GerritQueryException {
        final LinkedList<JSONObject> list = new LinkedList<JSONObject>();
        this.runQuery(queryString, getPatchSets, getCurrentPatchSet, getFiles, new LineVisitor(){

            @Override
            public void visit(String line) throws GerritQueryException {
                JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)line.trim());
                if (json.has("type") && "error".equalsIgnoreCase(json.getString("type"))) {
                    throw new GerritQueryException(json.getString("message"));
                }
                list.add(json);
            }
        });
        return list;
    }

    public List<JSONObject> queryFiles(String queryString) throws SshException, IOException, GerritQueryException {
        return this.queryJava(queryString, false, true, true);
    }

    public List<String> queryJson(String queryString) throws SshException, IOException {
        return this.queryJson(queryString, true, true, false);
    }

    public List<String> queryJson(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles) throws SshException, IOException {
        final LinkedList<String> list = new LinkedList<String>();
        try {
            this.runQuery(queryString, getPatchSets, getCurrentPatchSet, getFiles, new LineVisitor(){

                @Override
                public void visit(String line) {
                    list.add(line.trim());
                }
            });
        }
        catch (GerritQueryException gqe) {
            logger.error("This should not have happened!", (Throwable)gqe);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuery(String queryString, boolean getPatchSets, boolean getCurrentPatchSet, boolean getFiles, LineVisitor visitor) throws GerritQueryException, SshException, IOException {
        StringBuilder str = new StringBuilder(QUERY_COMMAND);
        str.append(" --format=JSON");
        if (getPatchSets) {
            str.append(" --patch-sets");
        }
        if (getCurrentPatchSet) {
            str.append(" --current-patch-set");
        }
        if (getFiles) {
            str.append(" --files");
        }
        str.append(" \"").append(queryString.replace("\"", "\\\"")).append("\"");
        SshConnection ssh = null;
        try {
            ssh = SshConnectionFactory.getConnection(this.gerritHostName, this.gerritSshPort, this.authentication);
            BufferedReader reader = new BufferedReader(ssh.executeCommandReader(str.toString()));
            String incomingLine = null;
            while ((incomingLine = reader.readLine()) != null) {
                logger.trace("Incoming line: {}", (Object)incomingLine);
                visitor.visit(incomingLine);
            }
            logger.trace("Closing reader.");
            reader.close();
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
    }

    static interface LineVisitor {
        public void visit(String var1) throws GerritQueryException;
    }
}

