/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritConnectionConfig;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.cmd.AbstractSendCommandJob;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritSendCommandQueue {
    private static final Logger logger = LoggerFactory.getLogger(GerritSendCommandQueue.class);
    private static GerritSendCommandQueue instance;
    private ThreadPoolExecutor executor = null;
    private static final int THREAD_KEEP_ALIVE_TIME = 20;
    public static final int SEND_QUEUE_SIZE_WARNING_THRESHOLD = 20;
    private static final int WAIT_FOR_JOBS_SHUTDOWN_TIMEOUT = 30;

    private GerritSendCommandQueue() {
    }

    public static synchronized GerritSendCommandQueue getInstance(GerritConnectionConfig config) {
        if (instance == null) {
            if (config == null) {
                throw new NullPointerException("A config instance is needed for the first init.");
            }
            instance = new GerritSendCommandQueue();
        }
        if (config != null) {
            instance.startQueue(config);
        }
        return instance;
    }

    public static void queue(AbstractSendCommandJob job) {
        GerritSendCommandQueue.getInstance(job.getConfig()).queueJob(job);
    }

    public static int getQueueSize() {
        if (instance != null && GerritSendCommandQueue.instance.executor != null) {
            return GerritSendCommandQueue.instance.executor.getQueue().size();
        }
        return 0;
    }

    public void queueJob(AbstractSendCommandJob job) {
        try {
            logger.debug("Queueing job {}", (Object)job);
            this.executor.submit(job);
        }
        catch (RejectedExecutionException e) {
            logger.error("Unable to queue a send-command-job! ", (Throwable)e);
        }
        int queueSize = GerritSendCommandQueue.getQueueSize();
        if (queueSize >= 20) {
            logger.warn("The Gerrit-trigger send commands queue contains {} items! Something might be stuck, or your system can't process the commands fast enough. Try to increase the number of sending worker threads on the Gerrit configuration page. Current thread-pool size: {}", (Object)queueSize, (Object)this.executor.getPoolSize());
            logger.info("Nr of active pool-threads: {}", (Object)this.executor.getActiveCount());
        }
    }

    protected void startQueue(GerritConnectionConfig config) {
        if (this.executor == null) {
            logger.debug("Starting the sending thread pool.");
            this.executor = new ThreadPoolExecutor(config.getNumberOfSendingWorkerThreads(), config.getNumberOfSendingWorkerThreads(), 20L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.executor.allowCoreThreadTimeOut(true);
            this.executor.prestartCoreThread();
            logger.info("SendQueue started! Current pool size: {}", (Object)this.executor.getPoolSize());
        } else {
            if (this.executor.getCorePoolSize() < config.getNumberOfSendingWorkerThreads()) {
                this.executor.setMaximumPoolSize(config.getNumberOfSendingWorkerThreads());
                this.executor.setCorePoolSize(config.getNumberOfSendingWorkerThreads());
            } else if (this.executor.getCorePoolSize() > config.getNumberOfSendingWorkerThreads()) {
                this.executor.setCorePoolSize(config.getNumberOfSendingWorkerThreads());
                this.executor.setMaximumPoolSize(config.getNumberOfSendingWorkerThreads());
            }
            logger.debug("SendQueue running. Current pool size: {}. Current Queue size: {}", (Object)this.executor.getPoolSize(), (Object)GerritSendCommandQueue.getQueueSize());
            logger.debug("Nr of active pool-threads: {}", (Object)this.executor.getActiveCount());
        }
    }

    public static void shutdown() {
        if (instance != null && GerritSendCommandQueue.instance.executor != null) {
            ThreadPoolExecutor pool = GerritSendCommandQueue.instance.executor;
            GerritSendCommandQueue.instance.executor = null;
            pool.shutdown();
            try {
                if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                        logger.error("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

