/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.attr;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.GerritJsonDTO;
import net.sf.json.JSONObject;

public class Account
implements GerritJsonDTO {
    private String name;
    private String email;

    public Account() {
    }

    public Account(JSONObject json) {
        this.fromJson(json);
    }

    public Account(String name, String email) {
        this.name = name;
        this.email = email;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.name = GerritJsonEventFactory.getString(json, "name");
        this.email = GerritJsonEventFactory.getString(json, "email");
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameAndEmail() {
        if (this.name == null || this.email == null) {
            return null;
        }
        if ("".equals(this.email) || "".equals(this.name)) {
            return "";
        }
        StringBuffer str = new StringBuffer("\"");
        str.append(this.name).append("\" <").append(this.email).append(">");
        return str.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        if (this.email != null ? !this.email.equals(account.email) : account.email != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(account.name) : account.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }
}

