/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.lifecycle;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.lifecycle.GerritEventLifecycleListener;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import java.util.LinkedList;
import java.util.List;

public abstract class GerritEventLifecycle {
    private transient List<GerritEventLifecycleListener> listeners;

    public synchronized void addListener(GerritEventLifecycleListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<GerritEventLifecycleListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized boolean removeListener(GerritEventLifecycleListener listener) {
        if (this.listeners != null) {
            return this.listeners.remove(listener);
        }
        return false;
    }

    public synchronized void fireTriggerScanStarting() {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, PatchsetCreated event) {
                listener.triggerScanStarting(event);
            }
        });
    }

    public synchronized void fireTriggerScanDone() {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, PatchsetCreated event) {
                listener.triggerScanDone(event);
            }
        });
    }

    public synchronized void fireProjectTriggered(final AbstractProject project) {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, PatchsetCreated event) {
                listener.projectTriggered(event, project);
            }
        });
    }

    public synchronized void fireBuildStarted(final AbstractBuild build) {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, PatchsetCreated event) {
                listener.buildStarted(event, build);
            }
        });
    }

    public synchronized void fireBuildCompleted(final AbstractBuild build) {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, PatchsetCreated event) {
                listener.buildCompleted(event, build);
            }
        });
    }

    public synchronized void fireAllBuildsCompleted() {
        this.fireEvent(new ListenerVisitor(){

            @Override
            public void visit(GerritEventLifecycleListener listener, PatchsetCreated event) {
                listener.allBuildsCompleted(event);
            }
        });
    }

    private synchronized void fireEvent(ListenerVisitor visitor) {
        if (this.listeners != null) {
            PatchsetCreated event = null;
            if (this instanceof PatchsetCreated) {
                event = (PatchsetCreated)this;
            }
            List<GerritEventLifecycleListener> list = this.getListeners();
            for (GerritEventLifecycleListener listener : list) {
                visitor.visit(listener, event);
            }
        }
    }

    protected synchronized List<GerritEventLifecycleListener> getListeners() {
        if (this.listeners != null) {
            return new LinkedList<GerritEventLifecycleListener>(this.listeners);
        }
        return null;
    }

    private static interface ListenerVisitor {
        public void visit(GerritEventLifecycleListener var1, PatchsetCreated var2);
    }
}

