/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.Authentication;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshConnection;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ssh.SshException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionImpl
implements SshConnection {
    private static final Logger logger = LoggerFactory.getLogger(SshConnectionImpl.class);
    private static final int ALIVE_INTERVAL = 30000;
    protected static final String CMD_EXEC = "exec";
    private final JSch client;
    private Session connectSession;
    private Channel currentSession;

    protected SshConnectionImpl(String host, int port, Authentication authentication) throws SshException, IOException {
        logger.debug("connecting...");
        try {
            this.client = new JSch();
            this.client.addIdentity(authentication.getPrivateKeyFile().getAbsolutePath(), authentication.getPrivateKeyFilePassword());
            this.client.setHostKeyRepository((HostKeyRepository)new BlindHostKeyRepository());
            this.connectSession = this.client.getSession(authentication.getUsername(), host, port);
            this.connectSession.connect();
            logger.debug("Connected: {}", (Object)this.connectSession.isConnected());
            this.connectSession.setServerAliveInterval(30000);
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.isAuthenticated();
    }

    @Override
    public synchronized boolean isAuthenticated() {
        return this.client != null && this.connectSession != null && this.connectSession.isConnected();
    }

    @Override
    public synchronized boolean isSessionOpen() {
        return this.currentSession != null && this.currentSession.isConnected() && !this.currentSession.isEOF();
    }

    @Override
    public synchronized String executeCommand(String command) throws SshException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected!");
        }
        try {
            logger.debug("Opening channel");
            Channel channel = this.connectSession.openChannel(CMD_EXEC);
            ((ChannelExec)channel).setCommand(command);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(channel.getInputStream()));
            logger.debug("connecting channel.");
            channel.connect();
            String incomingLine = null;
            StringBuilder commandOutput = new StringBuilder();
            while ((incomingLine = bufferedReader.readLine()) != null) {
                commandOutput.append(incomingLine);
                commandOutput.append('\n');
                logger.trace("Incoming line: {}", (Object)incomingLine);
            }
            logger.trace("Closing reader.");
            bufferedReader.close();
            logger.trace("disconnecting channel.");
            channel.disconnect();
            return commandOutput.toString();
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
        catch (IOException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public synchronized Reader executeCommandReader(String command) throws SshException, IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected!");
        }
        try {
            Channel channel = this.connectSession.openChannel(CMD_EXEC);
            ((ChannelExec)channel).setCommand(command);
            InputStreamReader reader = new InputStreamReader(channel.getInputStream());
            channel.connect();
            return reader;
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public synchronized ChannelExec executeCommandChannel(String command) throws SshException, IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected!");
        }
        try {
            ChannelExec channel = (ChannelExec)this.connectSession.openChannel(CMD_EXEC);
            channel.setCommand(command);
            channel.connect();
            return channel;
        }
        catch (JSchException ex) {
            throw new SshException(ex);
        }
    }

    @Override
    public synchronized void disconnect() {
        if (this.isSessionOpen()) {
            logger.debug("Closing ssh session.");
            this.currentSession.disconnect();
            this.currentSession = null;
        }
        if (this.isConnected()) {
            logger.debug("Disconnecting client connection.");
            this.connectSession.disconnect();
            this.connectSession = null;
        }
    }

    static class BlindHostKeyRepository
    implements HostKeyRepository {
        private static final HostKey[] EMPTY = new HostKey[0];

        BlindHostKeyRepository() {
        }

        public int check(String host, byte[] key) {
            return 0;
        }

        public void add(HostKey hostkey, UserInfo ui) {
        }

        public void remove(String host, String type) {
        }

        public void remove(String host, String type, byte[] key) {
        }

        public String getKnownHostsRepositoryID() {
            return "";
        }

        public HostKey[] getHostKey() {
            return EMPTY;
        }

        public HostKey[] getHostKey(String host, String type) {
            return EMPTY;
        }
    }
}

