/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.Coordinator;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.workers.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(EventThread.class);
    private Coordinator coordinator;
    private boolean shutdown = false;

    public EventThread(Coordinator coordinator) {
        this(coordinator, "Gerrit Worker EventThread");
    }

    public EventThread(Coordinator coordinator, String name) {
        super("Gerrit Worker EventThread");
        this.coordinator = coordinator;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                Work work = this.coordinator.getWorkQueue().take();
                work.perform(this.coordinator);
            }
            catch (InterruptedException ex) {
                logger.debug("Got interrupted while polling work queue", (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        logger.debug("Shutting down worker: {}", (Object)this);
        this.shutdown = true;
        this.interrupt();
    }
}

